/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.WrappedItem;
import cubex2.cs3.item.attributes.SwordAttributes;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.world.World;

public class ItemCSSword
extends ItemSword {
    private BaseContentPack pack;
    private WrappedItem wrappedItem;
    private SwordAttributes attributes;

    public ItemCSSword(WrappedItem item) {
        super(Item.ToolMaterial.STONE);
        this.pack = item.getPack();
        this.wrappedItem = item;
        this.attributes = (SwordAttributes)item.container;
    }

    public void setHarvestLevel(String toolClass, int level) {
        if (!toolClass.equals("noHarvest") && !toolClass.equals("all")) {
            super.setHarvestLevel(toolClass, level);
        }
    }

    public void func_94581_a(IIconRegister p_94581_1_) {
        super.func_94581_a(p_94581_1_);
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.wrappedItem.getItemStackLimit(stack);
    }

    public boolean func_77662_d() {
        return this.wrappedItem.isFull3D();
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.wrappedItem.hasEffect(stack);
    }

    public CreativeTabs func_77640_w() {
        return this.wrappedItem.getCreativeTab();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        return this.wrappedItem.onItemRightClick(stack, world, player);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return this.wrappedItem.onItemUse(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return this.wrappedItem.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target) {
        return this.wrappedItem.useItemOnEntity(stack, player, target);
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase living) {
        if ((double)block.func_149712_f(world, x, y, z) != 0.0) {
            stack.func_77972_a(2, living);
        }
        return this.wrappedItem.onBlockDestroyed(stack, world, block, x, y, z, living);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase living1, EntityLivingBase living2) {
        stack.func_77972_a(1, living2);
        return this.wrappedItem.hitEntity(stack, living1, living2);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return this.wrappedItem.onLeftClickEntity(stack, player, entity);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isCurrentItem) {
        this.wrappedItem.onUpdate(stack, world, entity, slotId, isCurrentItem);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        this.wrappedItem.onCreated(stack, world, player);
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int tickCount) {
        this.wrappedItem.onUsingTick(stack, player, tickCount);
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int tickCount) {
        this.wrappedItem.onPlayerStoppedUsing(stack, world, player, tickCount);
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        return this.wrappedItem.onDroppedByPlayer(stack, player);
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        return this.wrappedItem.onBlockStartBreak(stack, x, y, z, player);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        return this.wrappedItem.onEaten(stack, world, player);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (block == Blocks.field_150321_G) {
            return 15.0f;
        }
        Material material = block.func_149688_o();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? this.wrappedItem.getDigSpeed(stack, block, meta) : 1.5f;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return block == Blocks.field_150321_G || this.wrappedItem.canHarvestBlock(block);
    }

    public int func_77626_a(ItemStack stack) {
        return this.wrappedItem.getMaxItemUseDuration(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        this.wrappedItem.addInformation(stack, player, list, advanced);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.wrappedItem.getItemUseAction(stack);
    }

    public int func_77612_l() {
        return this.wrappedItem.getMaxDamage();
    }

    public boolean func_77645_m() {
        return this.wrappedItem.isDamageable();
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        return this.wrappedItem.getAttributeModifiers((Multimap)HashMultimap.create(), field_111210_e);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.wrappedItem.hasContainerItem(stack);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return this.wrappedItem.getContainerItem(stack);
    }

    public boolean func_77630_h(ItemStack stack) {
        return this.wrappedItem.doesContainerItemLeaveCraftingGrid(stack);
    }

    public int func_77619_b() {
        return this.wrappedItem.getItemEnchantability();
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return this.wrappedItem.getIsRepairable(stack, material);
    }
}

