/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cubex2.cs3.api.scripting.TriggerType;
import cubex2.cs3.common.WrappedItem;
import cubex2.cs3.common.scripting.TriggerData;
import cubex2.cs3.item.attributes.ArmorAttributes;
import cubex2.cs3.util.JavaScriptHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public abstract class ItemCSArmor
extends ItemArmor {
    private WrappedItem wrappedItem;
    private ArmorAttributes container;

    public ItemCSArmor(WrappedItem item, int type) {
        super(((ArmorAttributes)item.container).material, 0, type);
        this.wrappedItem = item;
        this.container = (ArmorAttributes)this.wrappedItem.container;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (this.container.onArmorUpdate != null && this.container.onArmorUpdate.script != null) {
            TriggerData data = new TriggerData("onArmorUpdate", TriggerType.ITEM, world, player, itemStack);
            JavaScriptHelper.executeTrigger(this.container.onArmorUpdate.script, data, this.wrappedItem.getPack());
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return this.container.texture;
    }

    public boolean func_77623_v() {
        return false;
    }

    public int func_82790_a(ItemStack p_82790_1_, int p_82790_2_) {
        return 0xFFFFFF;
    }

    public IIcon func_77618_c(int p_77618_1_, int p_77618_2_) {
        return this.field_77791_bV;
    }

    public boolean func_77662_d() {
        return this.wrappedItem.isFull3D();
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.wrappedItem.hasEffect(stack);
    }

    public CreativeTabs func_77640_w() {
        return this.wrappedItem.getCreativeTab();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        super.func_77659_a(stack, world, player);
        if (stack.field_77994_a == 0) {
            return stack;
        }
        return this.wrappedItem.onItemRightClick(stack, world, player);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return this.wrappedItem.onItemUse(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return this.wrappedItem.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target) {
        return this.wrappedItem.useItemOnEntity(stack, player, target);
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase living) {
        return this.wrappedItem.onBlockDestroyed(stack, world, block, x, y, z, living);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase living1, EntityLivingBase living2) {
        return this.wrappedItem.hitEntity(stack, living1, living2);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return this.wrappedItem.onLeftClickEntity(stack, player, entity);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isCurrentItem) {
        this.wrappedItem.onUpdate(stack, world, entity, slotId, isCurrentItem);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        this.wrappedItem.onCreated(stack, world, player);
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int tickCount) {
        this.wrappedItem.onUsingTick(stack, player, tickCount);
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int tickCount) {
        this.wrappedItem.onPlayerStoppedUsing(stack, world, player, tickCount);
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        return this.wrappedItem.onDroppedByPlayer(stack, player);
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        return this.wrappedItem.onBlockStartBreak(stack, x, y, z, player);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        return this.wrappedItem.onEaten(stack, world, player);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        return this.wrappedItem.getDigSpeed(stack, block, meta);
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return this.wrappedItem.canHarvestBlock(block);
    }

    public int func_77626_a(ItemStack stack) {
        return this.wrappedItem.getMaxItemUseDuration(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        this.wrappedItem.addInformation(stack, player, list, advanced);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.wrappedItem.getItemUseAction(stack);
    }

    public boolean func_77645_m() {
        return this.wrappedItem.isDamageable();
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        return this.wrappedItem.getAttributeModifiers((Multimap)HashMultimap.create(), field_111210_e);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.wrappedItem.hasContainerItem(stack);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return this.wrappedItem.getContainerItem(stack);
    }

    public boolean func_77630_h(ItemStack stack) {
        return this.wrappedItem.doesContainerItemLeaveCraftingGrid(stack);
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return this.wrappedItem.getIsRepairable(stack, material);
    }
}

