/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.item;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.WrappedItem;
import cubex2.cs3.common.client.renderer.CSItemRenderer;
import cubex2.cs3.item.ItemCS;
import cubex2.cs3.item.ItemCSAxe;
import cubex2.cs3.item.ItemCSBoots;
import cubex2.cs3.item.ItemCSBucket;
import cubex2.cs3.item.ItemCSFood;
import cubex2.cs3.item.ItemCSHelmet;
import cubex2.cs3.item.ItemCSLegs;
import cubex2.cs3.item.ItemCSPickaxe;
import cubex2.cs3.item.ItemCSPlate;
import cubex2.cs3.item.ItemCSShovel;
import cubex2.cs3.item.ItemCSSword;
import cubex2.cs3.item.attributes.ArmorAttributes;
import cubex2.cs3.item.attributes.AxeAttributes;
import cubex2.cs3.item.attributes.BucketAttributes;
import cubex2.cs3.item.attributes.FoodAttributes;
import cubex2.cs3.item.attributes.ItemAttributes;
import cubex2.cs3.item.attributes.PickaxeAttributes;
import cubex2.cs3.item.attributes.ShovelAttributes;
import cubex2.cs3.item.attributes.SwordAttributes;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public enum EnumItemType {
    AXE("axe", ItemCSAxe.class, AxeAttributes.class),
    BOOTS("boots", ItemCSBoots.class, ArmorAttributes.class),
    BUCKET("bucket", ItemCSBucket.class, BucketAttributes.class),
    FOOD("food", ItemCSFood.class, FoodAttributes.class),
    HELMET("helmet", ItemCSHelmet.class, ArmorAttributes.class),
    LEGS("legs", ItemCSLegs.class, ArmorAttributes.class),
    NORMAL("normal", ItemCS.class, ItemAttributes.class),
    PICKAXE("pickaxe", ItemCSPickaxe.class, PickaxeAttributes.class),
    PLATE("plate", ItemCSPlate.class, ArmorAttributes.class),
    SHOVEL("shovel", ItemCSShovel.class, ShovelAttributes.class),
    SWORD("sword", ItemCSSword.class, SwordAttributes.class);

    public final String name;
    public final Class<? extends Item> itemClass;
    public final Class<? extends ItemAttributes> attributesClass;
    private static final Map<String, EnumItemType> map;

    private EnumItemType(String name, Class<? extends Item> itemClass, Class<? extends ItemAttributes> attributesClass) {
        this.name = name;
        this.itemClass = itemClass;
        this.attributesClass = attributesClass;
    }

    public Item createItem(WrappedItem wrappedItem) {
        try {
            Item item = this.itemClass.getConstructor(WrappedItem.class).newInstance(wrappedItem);
            GameRegistry.registerItem((Item)item, (String)wrappedItem.getName());
            if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                this.registerRender(item, wrappedItem);
            }
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerRender(Item item, WrappedItem wrappedItem) {
        MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)new CSItemRenderer(wrappedItem));
    }

    public ItemAttributes createAttributeContainer(WrappedItem item) {
        try {
            return this.attributesClass.getConstructor(BaseContentPack.class).newInstance(item.getPack());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static EnumItemType get(String name) {
        if (map.isEmpty()) {
            for (EnumItemType e : EnumItemType.values()) {
                map.put(e.name, e);
            }
        }
        return map.get(name);
    }

    public static String[] getNames() {
        String[] names = new String[EnumItemType.values().length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = EnumItemType.values()[i].name;
        }
        return names;
    }

    static {
        map = Maps.newHashMap();
    }
}

