/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.worldgen;

import cubex2.cs3.common.WrappedWorldGen;
import cubex2.cs3.ingame.gui.control.NumericUpDown;
import cubex2.cs3.ingame.gui.control.WorldDisplay;
import cubex2.cs3.ingame.gui.worldgen.WindowEditWorldGenAttribute;
import cubex2.cs3.util.SimulatedWorld;
import cubex2.cs3.worldgen.attributes.WorldGenOreAttributes;
import java.util.Random;
import net.minecraft.init.Blocks;

public class WindowEditAmount
extends WindowEditWorldGenAttribute {
    private static final int MINX = -20;
    private static final int MINY = -20;
    private static final int MINZ = -20;
    private static final int MAXX = 20;
    private static final int MAXY = 20;
    private static final int MAXZ = 20;
    private Random random = new Random();
    private NumericUpDown nupAmount;
    private WorldDisplay display;
    private SimulatedWorld world;
    private WorldGenOreAttributes container;
    private int tickCounter;
    private int prevAmount;

    public WindowEditAmount(WrappedWorldGen wrappedWorldGen) {
        super(wrappedWorldGen, "amount", 34, 150, 150);
        this.container = (WorldGenOreAttributes)wrappedWorldGen.container;
        this.prevAmount = this.container.amount;
        this.world = new SimulatedWorld(-20, -20, -20, 20, 20, 20);
        this.nupAmount = (NumericUpDown)this.numericUpDown().at(7, 7).fillWidth(7).add();
        this.nupAmount.setMaxValue(100);
        this.nupAmount.setValue(this.container.amount);
        this.display = (WorldDisplay)this.worldDisplay(this.world).below(this.nupAmount).right(7).bottom(this.btnCancel, 5).add();
        this.display.rotate = false;
        this.display.setLook(0.5f, 0.5f, 0.5f);
        this.display.setCam(7.0f, 7.0f, 7.0f);
        this.generateBlocks();
    }

    @Override
    protected void applyChanges() {
        this.container.amount = this.nupAmount.getValue();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        ++this.tickCounter;
        if (this.tickCounter % 20 == 0) {
            this.generateBlocks();
        }
    }

    private void generateBlocks() {
        this.world.clear();
        this.container.amount = this.nupAmount.getValue();
        this.wrappedWorldGen.worldGen.generateInSimWorld(this.world, this.random);
        this.container.amount = this.prevAmount;
        int minX = this.findMinX();
        if (minX < -20) {
            return;
        }
        int maxX = this.findMaxX();
        int minY = this.findMinY();
        int maxY = this.findMaxY();
        int minZ = this.findMinZ();
        int maxZ = this.findMaxZ();
        float lookX = minX + (maxX - minX) / 2;
        float lookY = minY + (maxY - minY) / 2;
        float lookZ = minZ + (maxZ - minZ) / 2;
        this.display.setLook(lookX, lookY, lookZ);
        this.display.setCam(lookX + 7.0f, lookY + 7.0f, lookZ + 7.0f);
    }

    private int findMinX() {
        for (int x = -20; x <= 20; ++x) {
            for (int y = -20; y <= 20; ++y) {
                for (int z = -20; z <= 20; ++z) {
                    if (this.world.func_147439_a(x, y, z) == Blocks.field_150350_a) continue;
                    return x;
                }
            }
        }
        return -21;
    }

    private int findMinY() {
        for (int y = -20; y <= 20; ++y) {
            for (int x = -20; x <= 20; ++x) {
                for (int z = -20; z <= 20; ++z) {
                    if (this.world.func_147439_a(x, y, z) == Blocks.field_150350_a) continue;
                    return y;
                }
            }
        }
        return -11;
    }

    private int findMinZ() {
        for (int z = -20; z <= 20; ++z) {
            for (int y = -20; y <= 20; ++y) {
                for (int x = -20; x <= 20; ++x) {
                    if (this.world.func_147439_a(x, y, z) == Blocks.field_150350_a) continue;
                    return z;
                }
            }
        }
        return -11;
    }

    private int findMaxX() {
        for (int x = 20; x >= -20; --x) {
            for (int y = -20; y <= 20; ++y) {
                for (int z = -20; z <= 20; ++z) {
                    if (this.world.func_147439_a(x, y, z) == Blocks.field_150350_a) continue;
                    return x;
                }
            }
        }
        return -11;
    }

    private int findMaxY() {
        for (int y = 20; y >= -20; --y) {
            for (int x = -20; x <= 20; ++x) {
                for (int z = -20; z <= 20; ++z) {
                    if (this.world.func_147439_a(x, y, z) == Blocks.field_150350_a) continue;
                    return y;
                }
            }
        }
        return -11;
    }

    private int findMaxZ() {
        for (int z = 20; z >= -20; --z) {
            for (int y = -20; y <= 20; ++y) {
                for (int x = -20; x <= 20; ++x) {
                    if (this.world.func_147439_a(x, y, z) == Blocks.field_150350_a) continue;
                    return z;
                }
            }
        }
        return -11;
    }
}

