/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.worldgen;

import com.google.common.collect.Lists;
import cubex2.cs3.common.WrappedWorldGen;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.ISelectElementCallback;
import cubex2.cs3.ingame.gui.WindowSelectString;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.listbox.IListBoxItemClickListener;
import cubex2.cs3.ingame.gui.control.listbox.ListBox;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;
import cubex2.cs3.ingame.gui.worldgen.WindowEditWorldGenAttribute;
import cubex2.cs3.lib.Biomes;
import cubex2.cs3.worldgen.attributes.WorldGenAttributes;
import java.util.ArrayList;
import java.util.List;

public class WindowEditAllowedBiomes
extends WindowEditWorldGenAttribute
implements IListBoxItemClickListener<String>,
ISelectElementCallback<String> {
    private ListBox<String> listBox;
    private List<String> biomes;

    public WindowEditAllowedBiomes(WrappedWorldGen wrappedWorldGen) {
        super(wrappedWorldGen, "allowedBiomes", 25, 256, 150);
        this.btnCreate.setText("Add");
        this.btnDelete.setText("Remove");
        this.btnDelete.setEnabled(false);
        this.biomes = Lists.newArrayList((Object[])((WorldGenAttributes)this.container).allowedBiomes);
        ListBoxDescription desc = new ListBoxDescription();
        desc.elements = this.biomes;
        desc.columns = 1;
        desc.sorted = true;
        desc.elementHeight = 18;
        desc.rows = 4;
        this.listBox = (ListBox)this.listBox(desc).at(7, 7).right(7).add();
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCreate) {
            WindowSelectString window = new WindowSelectString("Select Biome", this.getBiomes());
            window.setCallback(this);
            GuiBase.openWindow(window);
        } else if (c == this.btnDelete) {
            this.biomes.remove(this.listBox.getSelectedItem());
            this.listBox.updateElements(this.biomes);
        } else if (c == this.btnBack) {
            this.handleEditButtonClicked();
        } else {
            super.controlClicked(c, mouseX, mouseY);
        }
    }

    @Override
    protected void applyChanges() {
        ((WorldGenAttributes)this.container).allowedBiomes = this.biomes.toArray(new String[this.biomes.size()]);
    }

    private List<String> getBiomes() {
        ArrayList ret = Lists.newArrayList();
        ret.add("all");
        for (String biome : Biomes.getBiomeNames()) {
            ret.add(biome);
        }
        for (String s : this.biomes) {
            ret.remove(s);
        }
        return ret;
    }

    @Override
    public void itemClicked(String item, ListBox<String> listBox, int button) {
        this.btnDelete.setEnabled(listBox.getSelectedItem() != null);
    }

    @Override
    public void itemSelected(String element) {
        this.biomes.add(element);
        this.listBox.updateElements(this.biomes);
    }
}

