/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.worldgen;

import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.WrappedWorldGen;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.DropBox;
import cubex2.cs3.ingame.gui.control.IStringProvider;
import cubex2.cs3.ingame.gui.control.IValidityProvider;
import cubex2.cs3.ingame.gui.control.Label;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.worldgen.EnumWorldGenType;

public class WindowCreateWorldGen
extends Window
implements IValidityProvider,
IStringProvider<EnumWorldGenType> {
    private final BaseContentPack pack;
    private Label lblName;
    private TextBox tbName;
    private Label lblType;
    private DropBox<EnumWorldGenType> dbType;

    public WindowCreateWorldGen(BaseContentPack pack) {
        super("New World Gen", 10, 180, 201);
        this.pack = pack;
        this.lblName = (Label)this.label("Name:").at(7, 7).add();
        this.tbName = (TextBox)this.textBox().below(this.lblName).size(166, 17).add();
        this.lblType = (Label)this.label("Type:").below(this.tbName, 5).add();
        this.dbType = (DropBox)this.dropBox(EnumWorldGenType.values()).below(this.lblType).size(100, 15).add();
        this.tbName.setValidityProvider(this);
        this.dbType.setStringProvider(this);
        this.dbType.setSelectedValue(EnumWorldGenType.ORE);
        this.btnCreate.setEnabled(false);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCreate) {
            WrappedWorldGen worldGen = new WrappedWorldGen(this.tbName.getText().trim(), this.dbType.getSelectedValue(), this.pack);
            worldGen.container = worldGen.getType().createAttributeContainer(worldGen);
            worldGen.worldGen = worldGen.getType().createWorldGen(worldGen);
            worldGen.apply();
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    public String checkValidity(TextBox tb) {
        String message = null;
        String text = tb.getText().trim();
        if (text.length() == 0) {
            message = "Enter a name";
        } else {
            for (WrappedWorldGen worldGen : this.pack.getContentRegistry(WrappedWorldGen.class).getContentList()) {
                if (!worldGen.getName().equals(text)) continue;
                message = "There is already a world gen with this name.";
                break;
            }
        }
        return message;
    }

    @Override
    public String getStringFor(EnumWorldGenType value) {
        return value.name;
    }
}

