/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.tileentity;

import cubex2.cs3.common.Fuel;
import cubex2.cs3.common.SmeltingRecipe;
import cubex2.cs3.common.WrappedTileEntity;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.DropBox;
import cubex2.cs3.ingame.gui.control.IValidityProvider;
import cubex2.cs3.ingame.gui.control.NumericUpDown;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.registry.FuelRegistry;
import cubex2.cs3.registry.SmeltingRecipeRegistry;
import cubex2.cs3.tileentity.attributes.TileEntityInventoryAttributes;
import cubex2.cs3.tileentity.data.FurnaceModule;

public class WindowEditOrCreateFurnaceModule
extends Window {
    private FurnaceModule editingModule;
    private WrappedTileEntity tile;
    private TextBox tbName;
    private DropBox<String> dbRecipes;
    private DropBox<String> dbFuels;
    private NumericUpDown nupInput;
    private NumericUpDown nupOutput;
    private NumericUpDown nupFuel;
    private NumericUpDown nupCookTime;

    public WindowEditOrCreateFurnaceModule(WrappedTileEntity tile, FurnaceModule module) {
        super("Edit Furnace Module", 34, 150, 220);
        this.tile = tile;
        this.editingModule = module;
        this.initControls();
    }

    public WindowEditOrCreateFurnaceModule(WrappedTileEntity tile) {
        super("New Furnace Module", 10, 150, 220);
        this.tile = tile;
        this.initControls();
    }

    private void initControls() {
        String[] recipeLists = ((SmeltingRecipeRegistry)this.tile.getPack().getContentRegistry(SmeltingRecipe.class)).getRecipeLists();
        String[] fuelLists = ((FuelRegistry)this.tile.getPack().getContentRegistry(Fuel.class)).getFuelLists();
        this.row("Name:");
        this.tbName = this.row(this.textBox());
        this.row("Recipe List:");
        this.dbRecipes = (DropBox)((Object)this.row(this.dropBox(recipeLists)));
        this.dbRecipes.setSelectedValue("vanilla");
        this.row("Fuel List:");
        this.dbFuels = (DropBox)((Object)this.row(this.dropBox(fuelLists)));
        this.dbFuels.setSelectedValue("vanilla");
        this.row("Input Slot:");
        this.nupInput = (NumericUpDown)this.numericUpDown().below(this.lastControl).width(65).add();
        this.nupOutput = (NumericUpDown)this.numericUpDown().rightTo(this.nupInput, 3).right(7).add();
        this.label("Output Slot:").left(this.nupOutput, 0, true).bottom(this.nupOutput, 3).add();
        this.label("Fuel Slot:").below(this.nupInput).add();
        this.nupFuel = (NumericUpDown)this.numericUpDown().below(this.lastControl).width(65).add();
        this.nupCookTime = (NumericUpDown)this.numericUpDown().rightTo(this.nupFuel, 3).right(7).add();
        this.label("Cook Time:").left(this.nupCookTime, 0, true).bottom(this.nupCookTime, 3).add();
        this.tbName.setValidityProvider(new NameValidator(this.tile, this.editingModule != null ? this.editingModule.name : null));
        this.nupCookTime.setValue(200);
        if (this.editingModule != null) {
            this.tbName.setText(this.editingModule.name);
            this.dbRecipes.setSelectedValue(this.editingModule.recipeList);
            this.dbFuels.setSelectedValue(this.editingModule.fuelList);
            this.nupInput.setValue(this.editingModule.inputSlot);
            this.nupOutput.setValue(this.editingModule.outputSlot);
            this.nupFuel.setValue(this.editingModule.fuelSlot);
            this.nupCookTime.setValue(this.editingModule.cookTime);
        }
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnEdit) {
            this.editingModule.name = this.tbName.getText();
            this.editingModule.recipeList = this.dbRecipes.getSelectedValue();
            this.editingModule.fuelList = this.dbFuels.getSelectedValue();
            this.editingModule.inputSlot = this.nupInput.getValue();
            this.editingModule.outputSlot = this.nupOutput.getValue();
            this.editingModule.fuelSlot = this.nupFuel.getValue();
            this.editingModule.cookTime = this.nupCookTime.getValue();
            this.tile.getPack().save();
            GuiBase.openPrevWindow();
        } else if (c == this.btnCreate) {
            FurnaceModule module = new FurnaceModule(this.tbName.getText(), this.dbRecipes.getSelectedValue(), this.dbFuels.getSelectedValue(), this.nupInput.getValue(), this.nupOutput.getValue(), this.nupFuel.getValue(), this.nupCookTime.getValue());
            ((TileEntityInventoryAttributes)this.tile.container).furnaceModules.list.add(module);
            this.tile.getPack().save();
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    public static class NameValidator
    implements IValidityProvider {
        private TileEntityInventoryAttributes container;
        private String current;

        public NameValidator(WrappedTileEntity tile, String current) {
            this.container = (TileEntityInventoryAttributes)tile.container;
            this.current = current;
        }

        @Override
        public String checkValidity(TextBox tb) {
            String message = null;
            String text = tb.getText().trim();
            if (text.length() == 0) {
                message = "Enter something";
            } else if (this.current == null || !text.equals(this.current)) {
                for (FurnaceModule module : this.container.furnaceModules.list) {
                    if (!module.name.equals(text)) continue;
                    message = "That name is already used.";
                    break;
                }
            }
            return message;
        }
    }
}

