/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.tileentity;

import com.google.common.collect.Lists;
import cubex2.cs3.common.WrappedTileEntity;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.listbox.IListBoxItemClickListener;
import cubex2.cs3.ingame.gui.control.listbox.ListBox;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;
import cubex2.cs3.ingame.gui.tileentity.WindowEditInventoryTEAttribute;
import cubex2.cs3.ingame.gui.tileentity.WindowEditOrCreateFurnaceModule;
import cubex2.cs3.tileentity.attributes.TileEntityInventoryAttributes;
import cubex2.cs3.tileentity.data.FurnaceModule;

public class WindowEditFurnaceModules
extends WindowEditInventoryTEAttribute
implements IListBoxItemClickListener<FurnaceModule>,
IWindowClosedListener<WindowEditOrCreateFurnaceModule> {
    private ListBox<FurnaceModule> listBox;

    public WindowEditFurnaceModules(WrappedTileEntity tile) {
        super(tile, "Furnace Modules", 53, 263, 160);
        ListBoxDescription desc = new ListBoxDescription(7, 7);
        desc.rows = 5;
        desc.columns = 1;
        desc.elementHeight = 22;
        desc.elements = Lists.newArrayList((Iterable)((TileEntityInventoryAttributes)this.container).furnaceModules.list);
        desc.canSelect = true;
        this.listBox = (ListBox)this.listBox(desc).fillWidth(7).top(7).add();
        this.btnEdit.setEnabled(false);
        this.btnDelete.setEnabled(false);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnNew) {
            GuiBase.openWindow(new WindowEditOrCreateFurnaceModule(this.wrappedTileEntity));
        } else if (c == this.btnEdit) {
            GuiBase.openWindow(new WindowEditOrCreateFurnaceModule(this.wrappedTileEntity, this.listBox.getSelectedItem()));
        } else if (c == this.btnDelete) {
            FurnaceModule rule = this.listBox.getSelectedItem();
            ((TileEntityInventoryAttributes)this.container).furnaceModules.list.remove(rule);
            this.listBox.updateElements(((TileEntityInventoryAttributes)this.container).furnaceModules.list);
            this.btnDelete.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.wrappedTileEntity.getPack().save();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    public void itemClicked(FurnaceModule item, ListBox<FurnaceModule> listBox, int button) {
        this.btnEdit.setEnabled(listBox.getSelectedIndex() != -1);
        this.btnDelete.setEnabled(listBox.getSelectedIndex() != -1);
    }

    @Override
    public void windowClosed(WindowEditOrCreateFurnaceModule window) {
        this.listBox.updateElements(((TileEntityInventoryAttributes)this.container).furnaceModules.list);
        this.btnEdit.setEnabled(this.listBox.getSelectedIndex() != -1);
        this.btnDelete.setEnabled(this.listBox.getSelectedIndex() != -1);
    }
}

