/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.tileentity;

import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.WrappedTileEntity;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.DropBox;
import cubex2.cs3.ingame.gui.control.IStringProvider;
import cubex2.cs3.ingame.gui.control.IValidityProvider;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.tileentity.EnumTileEntityType;

public class WindowCreateTileEntity
extends Window
implements IValidityProvider,
IStringProvider<EnumTileEntityType> {
    private final BaseContentPack pack;
    private TextBox tbName;
    private DropBox<EnumTileEntityType> dbType;

    public WindowCreateTileEntity(BaseContentPack pack) {
        super("New Tile Entity", 10, 180, 201);
        this.pack = pack;
        this.row("Name:");
        this.tbName = this.row(this.textBox());
        this.row("Type:");
        this.dbType = (DropBox)((Object)this.row(this.dropBox(EnumTileEntityType.values())));
        this.tbName.setValidityProvider(this);
        this.dbType.setStringProvider(this);
        this.dbType.setSelectedValue(EnumTileEntityType.NORMAL);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCreate) {
            WrappedTileEntity te = new WrappedTileEntity(this.tbName.getText(), this.dbType.getSelectedValue(), this.pack);
            te.container = te.getType().createAttributeContainer(te);
            te.apply();
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    public String getStringFor(EnumTileEntityType value) {
        return value.name;
    }

    @Override
    public String checkValidity(TextBox tb) {
        String message = null;
        String text = tb.getText().trim();
        if (text.length() == 0) {
            message = "Enter a name";
        } else {
            for (WrappedTileEntity te : this.pack.getContentRegistry(WrappedTileEntity.class).getContentList()) {
                if (!te.getName().equals(text)) continue;
                message = "There is already a tile entity with this name.";
                break;
            }
        }
        return message;
    }
}

