/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.item;

import com.google.common.collect.Lists;
import cubex2.cs3.common.WrappedItem;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.listbox.IListBoxItemClickListener;
import cubex2.cs3.ingame.gui.control.listbox.ListBox;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;
import cubex2.cs3.ingame.gui.item.WindowCreateToolClass;
import cubex2.cs3.ingame.gui.item.WindowEditItemAttribute;
import cubex2.cs3.util.ToolClass;
import java.util.List;

public class WindowEditToolClass
extends WindowEditItemAttribute
implements IWindowClosedListener<WindowCreateToolClass>,
IListBoxItemClickListener<ToolClass> {
    private List<ToolClass> toolClasses;
    private ListBox<ToolClass> lbToolClasses;

    public WindowEditToolClass(WrappedItem item) {
        super(item, "toolClass", 21, 200, 120);
        ListBoxDescription desc = new ListBoxDescription(7, 7);
        desc.rows = 6;
        desc.elements = Lists.newArrayList((Object[])item.container.toolClasses);
        desc.canSelect = true;
        this.lbToolClasses = (ListBox)this.listBox(desc).fillWidth(7).top(7).add();
        this.toolClasses = Lists.newArrayList((Object[])item.container.toolClasses);
        this.updateNewButton();
    }

    private void updateNewButton() {
        this.btnNew.setEnabled(this.toolClasses.size() != 1 || !this.toolClasses.get((int)0).toolClass.equals("noHarvest") && !this.toolClasses.get((int)0).toolClass.equals("all"));
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnNew) {
            GuiBase.openWindow(new WindowCreateToolClass(this.toolClasses.size() == 0));
        } else if (c == this.btnDelete) {
            ToolClass toolClass = this.lbToolClasses.getSelectedItem();
            this.toolClasses.remove(toolClass);
            this.lbToolClasses.updateElements(this.toolClasses);
            this.btnDelete.setEnabled(false);
            this.updateNewButton();
        } else if (c == this.btnBack) {
            this.applyChanges();
            this.saveAndClose();
        }
    }

    @Override
    protected void applyChanges() {
        for (ToolClass toolClass : this.wrappedItem.container.toolClasses) {
            this.wrappedItem.item.setHarvestLevel(toolClass.toolClass, -1);
        }
        for (ToolClass toolClass : this.wrappedItem.container.toolClasses = this.toolClasses.toArray(new ToolClass[this.toolClasses.size()])) {
            this.wrappedItem.item.setHarvestLevel(toolClass.toolClass, toolClass.harvestLevel);
        }
    }

    @Override
    public void itemClicked(ToolClass item, ListBox<ToolClass> listBox, int button) {
        this.btnDelete.setEnabled(listBox.getSelectedIndex() != -1);
    }

    @Override
    public void windowClosed(WindowCreateToolClass window) {
        if (window.getCreatedClass() != null) {
            this.toolClasses.add(window.getCreatedClass());
            this.lbToolClasses.updateElements(this.toolClasses);
            this.updateNewButton();
        }
    }
}

