/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.item;

import cubex2.cs3.common.WrappedItem;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.control.ButtonUpDown;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ItemDisplay;
import cubex2.cs3.ingame.gui.item.WindowEditItemAttribute;
import cubex2.cs3.item.attributes.ItemAttributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public class WindowEditMaxStack
extends WindowEditItemAttribute {
    private ItemDisplay itemDisplay;
    private ButtonUpDown btnUp;
    private ButtonUpDown btnDown;
    private int newMaxStack;

    public WindowEditMaxStack(WrappedItem item) {
        super(item, "maxStack", 34, 150, 100);
        this.newMaxStack = ((ItemAttributes)this.container).maxStack;
        this.itemDisplay = (ItemDisplay)this.itemDisplay().top(31).centerHor(-5).add();
        this.itemDisplay.setItemStack(new ItemStack(this.wrappedItem.item, this.newMaxStack, 0));
        this.itemDisplay.setDrawSlotBackground();
        this.btnUp = this.buttonUpDown(true).rightTo(this.itemDisplay).add();
        this.btnDown = this.buttonUpDown(false).rightTo(this.itemDisplay).add();
        this.maxStackChanged();
    }

    private void maxStackChanged() {
        this.btnUp.setEnabled(this.newMaxStack < 64);
        this.btnDown.setEnabled(this.newMaxStack > 1);
        this.itemDisplay.setStackSize(this.newMaxStack);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnUp || c == this.btnDown) {
            int numChange = (GuiBase.func_146272_n() ? 5 : 1) * (c == this.btnUp ? 1 : -1);
            this.newMaxStack = MathHelper.func_76125_a((int)(this.newMaxStack + numChange), (int)1, (int)64);
            this.maxStackChanged();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    protected void applyChanges() {
        ((ItemAttributes)this.container).maxStack = this.newMaxStack;
        this.wrappedItem.item.func_77625_d(this.newMaxStack);
    }
}

