/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.item;

import cubex2.cs3.common.WrappedItem;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.WindowSelectItem;
import cubex2.cs3.ingame.gui.control.CheckBox;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ItemDisplay;
import cubex2.cs3.ingame.gui.item.WindowEditItemAttribute;
import cubex2.cs3.item.attributes.ItemAttributes;
import net.minecraft.item.ItemStack;

public class WindowEditContainerItem
extends WindowEditItemAttribute
implements IWindowClosedListener<WindowSelectItem> {
    private ItemDisplay itemDisplay = (ItemDisplay)this.itemDisplay().top(8).centerHor().add();
    private CheckBox checkBox;

    public WindowEditContainerItem(WrappedItem item) {
        super(item, "containerItem", 150, 100);
        this.itemDisplay.setDrawSlotBackground();
        this.itemDisplay.setClearOnRightClick();
        this.itemDisplay.setItemStack(((ItemAttributes)this.container).containerItem);
        this.checkBox = (CheckBox)this.checkBox("Remain in crafting grid").below(this.itemDisplay, 5).left(7).add();
        this.checkBox.setIsChecked(((ItemAttributes)this.container).leaveContainerItem);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.itemDisplay) {
            GuiBase.openWindow(new WindowSelectItem(false));
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    protected void applyChanges() {
        ((ItemAttributes)this.container).containerItem = this.itemDisplay.getItemStack();
        ((ItemAttributes)this.container).leaveContainerItem = this.checkBox.getIsChecked();
    }

    @Override
    public void windowClosed(WindowSelectItem window) {
        ItemStack stack = window.getSelectedStack();
        if (stack != null) {
            this.itemDisplay.setItemStack(stack);
        }
    }
}

