/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.item;

import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.IValidityProvider;
import cubex2.cs3.ingame.gui.control.Label;
import cubex2.cs3.ingame.gui.control.NumericUpDown;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.util.ToolClass;

public class WindowCreateToolClass
extends Window
implements IValidityProvider {
    private TextBox tbToolClass;
    private NumericUpDown nupHarvestLevel;
    private final boolean harvestAndAll;
    private ToolClass createdClass = null;

    public WindowCreateToolClass(boolean harvestAndAll) {
        super("Add tool class", 10, 150, 120);
        this.harvestAndAll = harvestAndAll;
        Label lblToolClass = (Label)this.label("Tool class:").at(7, 7).add();
        this.infoButton("The tool class specifies on what| blocks the item is efficient.|You can use multiple| tool classes by using ',' as| a separator.|Common tool classes are:| pickaxe| axe| shovel|Special classes are:| noHarvest - can't break any blocks| all - effective on everything").rightTo(lblToolClass).add();
        this.tbToolClass = (TextBox)this.textBox().top(lblToolClass, 2).fillWidth(7).add();
        this.tbToolClass.setValidityProvider(this);
        Label lblHarvestLevel = this.label("Harvest level:").below(this.tbToolClass).add();
        this.infoButton("The harvest level of the|specified tool class.| 0 = wood / gold| 1 = stone| 2 = iron| 3 = diamond").rightTo(lblHarvestLevel).add();
        this.nupHarvestLevel = (NumericUpDown)this.numericUpDown().top(lblHarvestLevel, 2).fillWidth(7).add();
        this.nupHarvestLevel.setValue(0);
    }

    public ToolClass getCreatedClass() {
        return this.createdClass;
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCancel) {
            GuiBase.openPrevWindow();
        } else if (c == this.btnCreate) {
            this.createdClass = new ToolClass(this.tbToolClass.getText(), this.nupHarvestLevel.getValue());
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    public String checkValidity(TextBox tb) {
        String message = null;
        if (!this.harvestAndAll && (tb.getText().equals("all") || tb.getText().equals("noHarvest"))) {
            message = "all / noHarvest have to be the only tool class.";
        }
        return message;
    }
}

