/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.gui;

import cubex2.cs3.common.WrappedGui;
import cubex2.cs3.gui.data.ProgressData;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.DropBox;
import cubex2.cs3.ingame.gui.control.IStringProvider;
import cubex2.cs3.ingame.gui.control.ImageProgressBar;
import cubex2.cs3.ingame.gui.control.NumericUpDown;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.ingame.gui.control.TextureTextBox;
import cubex2.cs3.ingame.gui.gui.WindowEditOrCreateControl;
import cubex2.cs3.lib.TextBoxValidators;

public abstract class WindowProgress<T extends ImageProgressBar, U extends ProgressData>
extends WindowEditOrCreateControl<T, U>
implements IStringProvider<Integer> {
    protected TextBox tbName;
    protected TextureTextBox tbTexture;
    protected NumericUpDown nupU;
    protected NumericUpDown nupV;
    protected DropBox<Integer> dbDirection;

    public WindowProgress(String name, WrappedGui gui, Window window, int x, int y, int width, int height) {
        super("Create " + name + " Progress", gui, window, x, y, width, height);
    }

    public WindowProgress(String name, WrappedGui gui, Window window, T control, U data) {
        super("Edit " + name + " Progress", gui, window, control, data);
        this.tbName.setText(((ProgressData)data).name);
        this.tbTexture.setText(((ProgressData)data).texture != null ? ((ProgressData)data).texture.toString() : "");
        this.nupU.setValue(((ProgressData)data).u);
        this.nupV.setValue(((ProgressData)data).v);
        this.dbDirection.setSelectedValue(((ProgressData)data).direction);
    }

    @Override
    protected void initControls(boolean hasSize) {
        super.initControls(hasSize);
        this.row("Module Name");
        this.tbName = this.row(this.textBox());
        this.row("Texture");
        this.tbTexture = this.row(this.textureTextBox(this.pack, "gui"));
        this.row("Texture X");
        this.nupU = this.row(this.numericUpDown());
        this.row("Texture Y");
        this.nupV = this.row(this.numericUpDown());
        this.row("Progress Direction", "If the progress is reversed,|like for furnace fuel,|you still need to select|the direction in which the bar|fills:||bar empties downwards -> select up");
        this.dbDirection = (DropBox)((Object)this.row(this.dropBox(new Integer[]{0, 1, 2, 3})));
        this.dbDirection.setStringProvider(this);
        this.dbDirection.parentMouseOverCheck = false;
        this.tbName.setValidityProvider(TextBoxValidators.NOT_EMPTY);
        this.dbDirection.setSelectedValue(0);
    }

    @Override
    protected void edit() {
        ((ProgressData)this.data).name = this.tbName.getText();
        ((ProgressData)this.data).texture = ((ImageProgressBar)this.control).texture = this.tbTexture.getLocation();
        ((ProgressData)this.data).u = ((ImageProgressBar)this.control).u = this.nupU.getValue();
        ((ProgressData)this.data).v = ((ImageProgressBar)this.control).v = this.nupV.getValue();
        ((ProgressData)this.data).direction = ((ImageProgressBar)this.control).direction = this.dbDirection.getSelectedValue().intValue();
    }

    @Override
    public String getStringFor(Integer value) {
        switch (value) {
            case 0: {
                return "Up";
            }
            case 1: {
                return "Down";
            }
            case 2: {
                return "Left";
            }
            case 3: {
                return "Right";
            }
        }
        return "UNDEFINED";
    }
}

