/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.gui;

import cubex2.cs3.common.WrappedGui;
import cubex2.cs3.gui.EnumGuiType;
import cubex2.cs3.gui.WindowContainerNormal;
import cubex2.cs3.gui.WindowNormal;
import cubex2.cs3.gui.data.ButtonData;
import cubex2.cs3.gui.data.ControlData;
import cubex2.cs3.gui.data.CookProgressData;
import cubex2.cs3.gui.data.FuelProgressData;
import cubex2.cs3.gui.data.GuiData;
import cubex2.cs3.gui.data.LabelData;
import cubex2.cs3.gui.data.PlayerInventoryData;
import cubex2.cs3.gui.data.SlotData;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Button;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.CookProgressBar;
import cubex2.cs3.ingame.gui.control.FuelProgressBar;
import cubex2.cs3.ingame.gui.control.InventorySlot;
import cubex2.cs3.ingame.gui.control.Label;
import cubex2.cs3.ingame.gui.control.PlayerInventoryArea;
import cubex2.cs3.ingame.gui.gui.WindowButton;
import cubex2.cs3.ingame.gui.gui.WindowCookProgress;
import cubex2.cs3.ingame.gui.gui.WindowFuelProgress;
import cubex2.cs3.ingame.gui.gui.WindowInventorySlot;
import cubex2.cs3.ingame.gui.gui.WindowLabel;
import cubex2.cs3.ingame.gui.gui.WindowPlayerInventory;
import cubex2.cs3.util.GuiHelper;

public class WindowEditUserGui
extends Window {
    private final WrappedGui gui;
    private final GuiData guiData;
    private final Window window;
    private Button btnAddButton;
    private Button btnAddLabel;
    private Button btnAddPlayerInventory;
    private Button btnAddSlot;
    private Button btnAddCookProgress;
    private Button btnAddFuelProgress;
    private Button btnEditControl;
    private Button btnMode;
    private boolean moveMode = true;
    private Control selected = null;
    private Button clickedButton = null;
    private boolean holdOn = false;
    private boolean isCreatingControl = false;
    private int mouseDownX;
    private int mouseDownY;

    public WindowEditUserGui(WrappedGui gui) {
        super(1, GuiBase.INSTANCE.field_146294_l, GuiBase.INSTANCE.field_146295_m);
        this.gui = gui;
        this.guiData = gui.container.guiData;
        this.drawBackground = false;
        this.btnAddButton = (Button)this.button("Button").at(7, 7).size(60, 16).add();
        this.btnAddLabel = (Button)this.button("Label").below(this.btnAddButton).size(60, 16).add();
        this.btnEditControl = (Button)this.button("Edit Control").top(7).right(7).size(80, 16).add();
        this.btnEditControl.setEnabled(false);
        this.btnMode = (Button)this.button("Mode: Move").below(this.btnEditControl).size(80, 16).add();
        if (gui.getType() == EnumGuiType.NORMAL) {
            this.window = new WindowNormal(gui);
        } else {
            this.btnAddPlayerInventory = (Button)this.button("Player Inv").below(this.btnAddLabel).size(60, 16).add();
            this.btnAddSlot = (Button)this.button("Inv Slot").below(this.btnAddPlayerInventory).size(60, 16).add();
            this.btnAddCookProgress = (Button)this.button("Cook Prog").below(this.btnAddSlot).size(60, 16).add();
            this.btnAddFuelProgress = (Button)this.button("Fuel Prog").below(this.btnAddCookProgress).size(60, 16).add();
            this.window = new WindowContainerNormal(gui, null);
            this.window.drawSlots = true;
        }
        this.window.onParentResized();
    }

    private void switchMode() {
        this.moveMode = !this.moveMode;
        this.btnMode.setText("Mode: " + (this.moveMode ? "Move" : "Size"));
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnAddButton || c == this.btnAddLabel || c == this.btnAddPlayerInventory || c == this.btnAddSlot || c == this.btnAddCookProgress || c == this.btnAddFuelProgress) {
            this.controlButtonClicked(c);
        } else if (c == this.btnEditControl) {
            if (this.selected instanceof Button) {
                GuiBase.openWindow(new WindowButton(this.gui, this.window, (Button)this.selected, (ButtonData)this.selected.controlTag));
            } else if (this.selected instanceof Label) {
                GuiBase.openWindow(new WindowLabel(this.gui, this.window, (Label)this.selected, (LabelData)this.selected.controlTag));
            } else if (this.selected instanceof PlayerInventoryArea) {
                GuiBase.openWindow(new WindowPlayerInventory(this.gui, this.window, (PlayerInventoryArea)this.selected, (PlayerInventoryData)this.selected.controlTag));
            } else if (this.selected instanceof InventorySlot) {
                GuiBase.openWindow(new WindowInventorySlot(this.gui, this.window, (InventorySlot)this.selected, (SlotData)this.selected.controlTag));
            } else if (this.selected instanceof CookProgressBar) {
                GuiBase.openWindow(new WindowCookProgress(this.gui, this.window, (CookProgressBar)this.selected, (CookProgressData)this.selected.controlTag));
            } else if (this.selected instanceof FuelProgressBar) {
                GuiBase.openWindow(new WindowFuelProgress(this.gui, this.window, (FuelProgressBar)this.selected, (FuelProgressData)this.selected.controlTag));
            }
        } else if (c == this.btnMode) {
            this.switchMode();
        } else if (c == this.btnBack) {
            this.gui.getPack().save();
            GuiBase.openPrevWindow();
        }
    }

    private void controlButtonClicked(Control button) {
        this.clickedButton = (Button)button;
        this.holdOn = true;
        this.setAllControlsEnableState(false);
    }

    @Override
    public void onParentResized() {
        this.width = Math.min(GuiBase.INSTANCE.field_146294_l, 504);
        this.height = Math.min(GuiBase.INSTANCE.field_146295_m, 504);
        this.window.onParentResized();
        super.onParentResized();
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button, boolean intoControl) {
        if (this.holdOn) {
            this.holdOn = false;
            this.isCreatingControl = true;
        }
        if (this.isCreatingControl) {
            this.mouseDownX = mouseX;
            this.mouseDownY = mouseY;
            return;
        }
        Control c = this.window.getControlAt(mouseX, mouseY);
        if (c != null && c != this.window) {
            if (c == this.selected && button == 1) {
                this.setSelected(null);
            } else if (button == 0) {
                this.setSelected(c);
            }
            this.btnEditControl.setEnabled(this.selected != null);
        } else if (this.selected != null && c == this.window) {
            this.setSelected(null);
        } else {
            super.mouseClicked(mouseX, mouseY, button, intoControl);
        }
    }

    private void setAllControlsEnableState(boolean value) {
        this.btnAddButton.setEnabled(value);
        this.btnAddLabel.setEnabled(value);
        this.setEnabled(this.btnAddPlayerInventory, value);
        this.setEnabled(this.btnAddSlot, value);
        this.setEnabled(this.btnAddCookProgress, value);
        this.setEnabled(this.btnAddFuelProgress, value);
        this.btnMode.setEnabled(value);
        this.btnBack.setEnabled(value);
    }

    private void setEnabled(Control c, boolean value) {
        if (c != null) {
            c.setEnabled(value);
        }
    }

    @Override
    public void mouseUp(int mouseX, int mouseY, int button) {
        if (!this.holdOn && this.isCreatingControl) {
            int x1 = Math.min(this.mouseDownX, mouseX);
            int x2 = Math.max(this.mouseDownX, mouseX);
            int y1 = Math.min(this.mouseDownY, mouseY);
            int y2 = Math.max(this.mouseDownY, mouseY);
            int width = x2 - x1;
            int height = y2 - y1;
            x1 -= this.window.getX();
            y1 -= this.window.getY();
            if (this.clickedButton == this.btnAddButton) {
                GuiBase.openWindow(new WindowButton(this.gui, this.window, x1, y1, width, height));
            } else if (this.clickedButton == this.btnAddLabel) {
                GuiBase.openWindow(new WindowLabel(this.gui, this.window, x1, y1));
            } else if (this.clickedButton == this.btnAddPlayerInventory) {
                GuiBase.openWindow(new WindowPlayerInventory(this.gui, this.window, x1, y1));
            } else if (this.clickedButton == this.btnAddSlot) {
                GuiBase.openWindow(new WindowInventorySlot(this.gui, this.window, x1, y1));
            } else if (this.clickedButton == this.btnAddCookProgress) {
                GuiBase.openWindow(new WindowCookProgress(this.gui, this.window, x1, y1, width, height));
            } else if (this.clickedButton == this.btnAddFuelProgress) {
                GuiBase.openWindow(new WindowFuelProgress(this.gui, this.window, x1, y1, width, height));
            }
            this.setAllControlsEnableState(true);
            this.isCreatingControl = false;
            return;
        }
        super.mouseUp(mouseX, mouseY, button);
    }

    private void setSelected(Control c) {
        this.selected = c;
        this.btnEditControl.setEnabled(this.selected != null);
    }

    @Override
    public void keyTyped(char c, int key) {
        if (this.selected != null) {
            ControlData tag = (ControlData)this.selected.controlTag;
            if (key == 211) {
                this.window.getControls().remove(this.selected);
                this.gui.container.guiData.controls.remove(tag);
                this.setSelected(null);
            } else if (key == 205 || key == 203) {
                int dir;
                int n = dir = key == 205 ? 1 : -1;
                if (this.moveMode) {
                    this.selected.offsetX += dir;
                    tag.x += dir;
                } else if (tag.isSizeable()) {
                    this.selected.width += dir;
                    tag.width += dir;
                }
                this.selected.onParentResized();
            } else if (key == 208 || key == 200) {
                int dir;
                int n = dir = key == 208 ? 1 : -1;
                if (this.moveMode) {
                    this.selected.offsetY += dir;
                    tag.y += dir;
                } else if (tag.isSizeable()) {
                    this.selected.height += dir;
                    tag.height += dir;
                }
                this.selected.onParentResized();
            }
        }
        super.keyTyped(c, key);
    }

    @Override
    public void draw(int mouseX, int mouseY, float renderTick) {
        Control c;
        this.window.draw(mouseX, mouseY, renderTick);
        if (this.holdOn || this.isCreatingControl) {
            c = this.clickedButton;
            GuiHelper.drawBorder(c.getX() - 1, c.getY() - 1, c.getX() + c.getWidth() + 1, c.getY() + c.getHeight() + 1, -65536);
        }
        if (this.isCreatingControl) {
            if (this.clickedButton == this.btnAddLabel) {
                GuiHelper.drawRect(mouseX - 5, mouseY, mouseX + 6, mouseY + 1, -16776961);
                GuiHelper.drawRect(mouseX, mouseY - 5, mouseX + 1, mouseY + 6, -16776961);
            } else if (this.clickedButton == this.btnAddPlayerInventory) {
                GuiHelper.drawRect(mouseX, mouseY, mouseX + 162, mouseY + 76, -16776961);
            } else if (this.clickedButton == this.btnAddSlot) {
                GuiHelper.drawRect(mouseX, mouseY, mouseX + 18, mouseY + 18, -16776961);
            } else {
                int x1 = Math.min(this.mouseDownX, mouseX);
                int x2 = Math.max(this.mouseDownX, mouseX);
                int y1 = Math.min(this.mouseDownY, mouseY);
                int y2 = Math.max(this.mouseDownY, mouseY);
                GuiHelper.drawBorder(x1, y1, x2, y2, -16776961);
            }
        } else {
            c = this.selected;
            if (c != null) {
                GuiHelper.drawBorder(c.getX() - 1, c.getY() - 1, c.getX() + c.getWidth() + 1, c.getY() + c.getHeight() + 1, -65536);
            }
            if ((c = this.window.getControlAt(mouseX, mouseY)) != null && c != this.window) {
                GuiHelper.drawBorder(c.getX() - 1, c.getY() - 1, c.getX() + c.getWidth() + 1, c.getY() + c.getHeight() + 1, -1);
            }
        }
        super.draw(mouseX, mouseY, renderTick);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.window.drawForeground(mouseX, mouseY);
        super.drawForeground(mouseX, mouseY);
    }
}

