/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.gui;

import com.google.common.collect.Lists;
import cubex2.cs3.common.WrappedGui;
import cubex2.cs3.gui.attributes.GuiContainerAttributes;
import cubex2.cs3.gui.data.ShiftClickRule;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.listbox.IListBoxItemClickListener;
import cubex2.cs3.ingame.gui.control.listbox.ListBox;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;
import cubex2.cs3.ingame.gui.gui.WindowEditContainerGuiAttribute;
import cubex2.cs3.ingame.gui.gui.WindowEditOrCreateShiftClickRule;

public class WindowEditShiftClickRules
extends WindowEditContainerGuiAttribute
implements IListBoxItemClickListener<ShiftClickRule>,
IWindowClosedListener<WindowEditOrCreateShiftClickRule> {
    private ListBox<ShiftClickRule> listBox;

    public WindowEditShiftClickRules(WrappedGui gui) {
        super(gui, "Shift-Click Rules", 53, 263, 160);
        ListBoxDescription desc = new ListBoxDescription(7, 7);
        desc.rows = 5;
        desc.columns = 1;
        desc.elementHeight = 22;
        desc.elements = Lists.newArrayList((Iterable)((GuiContainerAttributes)this.container).shiftClickRules.list);
        desc.canSelect = true;
        this.listBox = (ListBox)this.listBox(desc).fillWidth(7).top(7).add();
        this.btnEdit.setEnabled(false);
        this.btnDelete.setEnabled(false);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnNew) {
            GuiBase.openWindow(new WindowEditOrCreateShiftClickRule(this.wrappedGui));
        } else if (c == this.btnEdit) {
            GuiBase.openWindow(new WindowEditOrCreateShiftClickRule(this.wrappedGui, this.listBox.getSelectedItem()));
        } else if (c == this.btnDelete) {
            ShiftClickRule rule = this.listBox.getSelectedItem();
            ((GuiContainerAttributes)this.container).shiftClickRules.list.remove(rule);
            this.listBox.updateElements(((GuiContainerAttributes)this.container).shiftClickRules.list);
            this.btnDelete.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.wrappedGui.getPack().save();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    public void itemClicked(ShiftClickRule item, ListBox<ShiftClickRule> listBox, int button) {
        this.btnEdit.setEnabled(listBox.getSelectedIndex() != -1);
        this.btnDelete.setEnabled(listBox.getSelectedIndex() != -1);
    }

    @Override
    public void windowClosed(WindowEditOrCreateShiftClickRule window) {
        this.listBox.updateElements(((GuiContainerAttributes)this.container).shiftClickRules.list);
        this.btnEdit.setEnabled(this.listBox.getSelectedIndex() != -1);
        this.btnDelete.setEnabled(this.listBox.getSelectedIndex() != -1);
    }
}

