/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.gui;

import cubex2.cs3.common.Fuel;
import cubex2.cs3.common.SmeltingRecipe;
import cubex2.cs3.common.WrappedGui;
import cubex2.cs3.gui.attributes.GuiContainerAttributes;
import cubex2.cs3.gui.data.ShiftClickRule;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.CheckBox;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.DropBox;
import cubex2.cs3.ingame.gui.control.NumericUpDown;
import cubex2.cs3.registry.FuelRegistry;
import cubex2.cs3.registry.SmeltingRecipeRegistry;

public class WindowEditOrCreateShiftClickRule
extends Window {
    private ShiftClickRule editingRule;
    private WrappedGui gui;
    private CheckBox cbFromInv;
    private CheckBox cbToInv;
    private NumericUpDown nbFromStart;
    private NumericUpDown nbFromEnd;
    private NumericUpDown nbToStart;
    private NumericUpDown nbToEnd;
    private CheckBox cbFuelOnly;
    private CheckBox cbInputOnly;
    private DropBox<String> dbRecipes;
    private DropBox<String> dbFuels;

    public WindowEditOrCreateShiftClickRule(WrappedGui gui, ShiftClickRule rule) {
        super("Edit Shift-Click Rule", 34, 150, 230);
        this.gui = gui;
        this.editingRule = rule;
        this.initControls();
    }

    public WindowEditOrCreateShiftClickRule(WrappedGui gui) {
        super("New Shift-Click Rule", 10, 150, 230);
        this.gui = gui;
        this.initControls();
    }

    private void initControls() {
        String[] recipeLists = ((SmeltingRecipeRegistry)this.gui.getPack().getContentRegistry(SmeltingRecipe.class)).getRecipeLists();
        String[] fuelLists = ((FuelRegistry)this.gui.getPack().getContentRegistry(Fuel.class)).getFuelLists();
        this.cbFromInv = this.row(this.checkBox("From Player Inventory"));
        this.row("From Start:");
        this.nbFromStart = (NumericUpDown)this.numericUpDown().below(this.lastControl).width(65).add();
        this.nbFromEnd = (NumericUpDown)this.numericUpDown().rightTo(this.nbFromStart, 3).right(7).add();
        this.label("From End:").left(this.nbFromEnd, 0, true).bottom(this.nbFromEnd, 3).add();
        this.cbToInv = (CheckBox)this.checkBox("To Player Inventory").below(this.nbFromStart, 7).add();
        this.label("To Start:").below(this.cbToInv).add();
        this.nbToStart = (NumericUpDown)this.numericUpDown().below(this.lastControl).width(65).add();
        this.nbToEnd = (NumericUpDown)this.numericUpDown().rightTo(this.nbToStart, 3).right(7).add();
        this.label("To End:").left(this.nbToEnd, 0, true).bottom(this.nbToEnd, 3).add();
        this.cbFuelOnly = (CheckBox)this.checkBox("Fuel Only").below(this.nbToStart, 7).add();
        this.label("Fuel List:").below(this.cbFuelOnly).add();
        this.dbFuels = (DropBox)this.dropBox(fuelLists).below(this.lastControl).right(7).add();
        this.dbFuels.setSelectedValue("vanilla");
        this.cbInputOnly = (CheckBox)this.checkBox("Furnace Input Only").below(this.dbFuels, 7).add();
        this.label("Recipe List:").below(this.cbInputOnly).add();
        this.dbRecipes = (DropBox)this.dropBox(recipeLists).below(this.lastControl).right(7).add();
        this.dbRecipes.setSelectedValue("vanilla");
        if (this.editingRule != null) {
            this.cbFromInv.setIsChecked(this.editingRule.fromInv);
            this.nbFromStart.setValue(this.editingRule.fromStart);
            this.nbFromEnd.setValue(this.editingRule.fromEnd);
            this.cbToInv.setIsChecked(this.editingRule.toInv);
            this.nbToStart.setValue(this.editingRule.toStart);
            this.nbToEnd.setValue(this.editingRule.toEnd);
            this.cbFuelOnly.setIsChecked(this.editingRule.fuelOnly);
            this.cbInputOnly.setIsChecked(this.editingRule.furnaceInputOnly);
            this.dbFuels.setSelectedValue(this.editingRule.fuelList);
            this.dbRecipes.setSelectedValue(this.editingRule.recipeList);
        }
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnEdit) {
            this.editingRule.fromInv = this.cbFromInv.getIsChecked();
            this.editingRule.fromStart = this.nbFromStart.getValue();
            this.editingRule.fromEnd = this.nbFromEnd.getValue();
            this.editingRule.toInv = this.cbToInv.getIsChecked();
            this.editingRule.toStart = this.nbToStart.getValue();
            this.editingRule.toEnd = this.nbToEnd.getValue();
            this.editingRule.fuelOnly = this.cbFuelOnly.getIsChecked();
            this.editingRule.furnaceInputOnly = this.cbInputOnly.getIsChecked();
            this.editingRule.recipeList = this.dbRecipes.getSelectedValue();
            this.editingRule.fuelList = this.dbFuels.getSelectedValue();
            this.gui.getPack().save();
            GuiBase.openPrevWindow();
        } else if (c == this.btnCreate) {
            ShiftClickRule rule = new ShiftClickRule(this.cbFromInv.getIsChecked(), this.nbFromStart.getValue(), this.nbFromEnd.getValue(), this.cbToInv.getIsChecked(), this.nbToStart.getValue(), this.nbToEnd.getValue(), this.cbFuelOnly.getIsChecked(), this.cbInputOnly.getIsChecked(), this.dbFuels.getSelectedValue(), this.dbRecipes.getSelectedValue());
            ((GuiContainerAttributes)this.gui.container).shiftClickRules.list.add(rule);
            this.gui.getPack().save();
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }
}

