/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.gui;

import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.WrappedGui;
import cubex2.cs3.gui.data.ControlData;
import cubex2.cs3.gui.data.GuiData;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ControlContainer;
import cubex2.cs3.ingame.gui.control.NumericUpDown;
import cubex2.cs3.ingame.gui.control.ScrollContainer;

public abstract class WindowEditOrCreateControl<T extends Control, U extends ControlData>
extends Window {
    protected BaseContentPack pack;
    protected GuiData guiData;
    protected Window window;
    protected NumericUpDown nupX;
    protected NumericUpDown nupY;
    protected NumericUpDown nupWidth;
    protected NumericUpDown nupHeight;
    protected T control;
    protected U data;
    private ScrollContainer scroll;
    protected ControlContainer content;

    public WindowEditOrCreateControl(String title, WrappedGui gui, Window window, int x, int y, int width, int height) {
        super(title, 10, 200, 200);
        this.pack = gui.getPack();
        this.guiData = gui.container.guiData;
        this.window = window;
        this.initControls(width != -1);
        this.scroll.automaticTotalHeight();
        this.nupX.setValue(x);
        this.nupY.setValue(y);
        if (width != -1) {
            this.nupWidth.setValue(width);
            this.nupHeight.setValue(height);
        }
        this.data = this.createData();
    }

    public WindowEditOrCreateControl(String title, WrappedGui gui, Window window, T control, U data) {
        super(title, 34, 200, 200);
        this.pack = gui.getPack();
        this.guiData = gui.container.guiData;
        this.window = window;
        this.control = control;
        this.data = data;
        this.initControls(((ControlData)data).isSizeable());
        this.scroll.automaticTotalHeight();
        this.nupX.setValue(((ControlData)data).x);
        this.nupY.setValue(((ControlData)data).y);
        if (((ControlData)data).isSizeable()) {
            this.nupWidth.setValue(((ControlData)data).width);
            this.nupHeight.setValue(((ControlData)data).height);
        }
    }

    protected void initControls(boolean hasSize) {
        this.scroll = (ScrollContainer)this.scrollContainer(1).fillWidth(7).top(7).bottom(this.btnCancel, 5).add();
        this.content = this.scroll.content();
        this.content.defaultNoOffset = true;
        this.defaultNoOffset = true;
        this.defaultBuilderContainer = this.content;
        this.row("X");
        this.nupX = this.row(this.numericUpDown());
        this.nupX.setMinValue(Integer.MIN_VALUE);
        this.row("Y");
        this.nupY = this.row(this.numericUpDown());
        this.nupY.setMinValue(Integer.MIN_VALUE);
        if (hasSize) {
            this.row("Width");
            this.nupWidth = this.row(this.numericUpDown());
            this.nupWidth.setMinValue(1);
            this.row("Height");
            this.nupHeight = this.row(this.numericUpDown());
            this.nupHeight.setMinValue(1);
        }
    }

    protected abstract U createData();

    protected abstract void edit();

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCreate) {
            U data = this.createData();
            this.guiData.add((ControlData)data);
            ((ControlData)data).addToWindow((Window)this.window, null).controlTag = data;
            GuiBase.openPrevWindow();
        } else if (c == this.btnEdit) {
            ((ControlData)this.data).x = this.nupX.getValue();
            ((ControlData)this.data).y = this.nupY.getValue();
            if (((ControlData)this.data).isSizeable()) {
                ((ControlData)this.data).width = this.nupWidth.getValue();
                ((ControlData)this.data).height = this.nupHeight.getValue();
            }
            this.edit();
            ((Control)this.control).offsetX = ((ControlData)this.data).x;
            ((Control)this.control).offsetY = ((ControlData)this.data).y;
            if (((ControlData)this.data).isSizeable()) {
                ((Control)this.control).width = ((ControlData)this.data).width;
                ((Control)this.control).height = ((ControlData)this.data).height;
            }
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }
}

