/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.gui;

import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.WrappedGui;
import cubex2.cs3.gui.EnumGuiType;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.DropBox;
import cubex2.cs3.ingame.gui.control.IStringProvider;
import cubex2.cs3.ingame.gui.control.IValidityProvider;
import cubex2.cs3.ingame.gui.control.TextBox;

public class WindowCreateGui
extends Window
implements IValidityProvider,
IStringProvider<EnumGuiType> {
    private final BaseContentPack pack;
    private TextBox tbName;
    private DropBox<EnumGuiType> dbType;

    public WindowCreateGui(BaseContentPack pack) {
        super("New GUI", 10, 180, 201);
        this.pack = pack;
        this.row("Name:");
        this.tbName = this.row(this.textBox());
        this.row("Type:");
        this.dbType = (DropBox)((Object)this.row(this.dropBox(EnumGuiType.values())));
        this.tbName.setValidityProvider(this);
        this.dbType.setStringProvider(this);
        this.dbType.setSelectedValue(EnumGuiType.NORMAL);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCreate) {
            WrappedGui gui = new WrappedGui(this.tbName.getText(), this.dbType.getSelectedValue(), this.pack);
            gui.container = gui.getType().createAttributeContainer(gui);
            gui.apply();
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    public String getStringFor(EnumGuiType value) {
        return value.name;
    }

    @Override
    public String checkValidity(TextBox tb) {
        String message = null;
        String text = tb.getText().trim();
        if (text.length() == 0) {
            message = "Enter a name";
        } else {
            for (WrappedGui gui : this.pack.getContentRegistry(WrappedGui.class).getContentList()) {
                if (!gui.getName().equals(text)) continue;
                message = "There is already a GUI with this name.";
                break;
            }
        }
        return message;
    }
}

