/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.event;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.WrappedEvent;
import cubex2.cs3.gui.EnumEventType;
import cubex2.cs3.gui.EnumSideType;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.DropBox;
import cubex2.cs3.ingame.gui.control.IStringProvider;
import cubex2.cs3.ingame.gui.control.IValidityProvider;
import cubex2.cs3.ingame.gui.control.TextBox;

public class WindowCreateEvent
extends Window
implements IValidityProvider,
IStringProvider<EventPriority> {
    private final BaseContentPack pack;
    private TextBox tbName;
    private DropBox<EnumEventType> dbEventType;
    private DropBox<EnumSideType> dbSideType;
    private DropBox<EventPriority> dbPriorityType;

    public WindowCreateEvent(BaseContentPack pack) {
        super("New Event", 10, 214, 201);
        this.pack = pack;
        this.row("Name:");
        this.tbName = this.row(this.textBox());
        this.row("Type:");
        this.dbEventType = (DropBox)((Object)this.row(this.dropBox(EnumEventType.values())));
        this.row("Side:");
        this.dbSideType = (DropBox)((Object)this.row(this.dropBox(EnumSideType.values())));
        this.row("Priority:");
        this.dbPriorityType = (DropBox)this.row(this.dropBox(EventPriority.values()));
        this.tbName.setValidityProvider(this);
        this.dbEventType.setSelectedValue(EnumEventType.LIVINGEVENTLIVINGUPDATEEVENT);
        this.dbSideType.setSelectedValue(EnumSideType.ALL);
        this.dbPriorityType.setStringProvider(this);
        this.dbPriorityType.setSelectedValue(EventPriority.NORMAL);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCreate) {
            WrappedEvent event = new WrappedEvent(this.tbName.getText(), this.dbEventType.getSelectedValue(), this.dbSideType.getSelectedValue(), this.dbPriorityType.getSelectedValue(), this.pack);
            event.apply();
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    public String checkValidity(TextBox tb) {
        String message = null;
        String text = tb.getText().trim();
        if (text.length() == 0) {
            message = "Enter a name";
        } else {
            for (WrappedEvent event : this.pack.getContentRegistry(WrappedEvent.class).getContentList()) {
                if (!event.getName().equals(text)) continue;
                message = "There is already a Event with this name.";
                break;
            }
        }
        return message;
    }

    @Override
    public String getStringFor(EventPriority value) {
        return value.name().toLowerCase();
    }
}

