/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control.listbox;

import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ControlContainer;
import cubex2.cs3.util.GuiHelper;

public class ListBoxItem<T>
extends ControlContainer {
    protected final T value;
    protected final int index;
    protected boolean drawDefaultBackground = true;
    private boolean isSelected = false;

    public ListBoxItem(T value, int idx, int width, int height, Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(width, height, anchor, offsetX, offsetY, parent);
        this.value = value;
        this.index = idx;
    }

    @Override
    public void mouseDown(int mouseX, int mouseY, int button) {
        super.mouseDown(mouseX, mouseY, button);
    }

    public void setSelected(boolean value) {
        this.isSelected = value;
        this.selectionChanged();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void selectionChanged() {
    }

    @Override
    public void draw(int mouseX, int mouseY, float renderTick) {
        if (this.drawDefaultBackground) {
            boolean isMouseOverControl = this.isMouseOverControl(mouseX, mouseY);
            int color1 = this.getDefaultColor1(this.isSelected, isMouseOverControl);
            int color2 = this.getDefaultColor2(this.isSelected, isMouseOverControl);
            GuiHelper.drawOutlinedRect(this.bounds, color1, color2);
        }
        super.draw(mouseX, mouseY, renderTick);
    }

    protected final int getDefaultColor1(boolean isSelected, boolean isMouseOver) {
        int color1 = -11842741;
        if (isMouseOver && isSelected) {
            color1 = -1;
        } else if (isMouseOver) {
            color1 = -1;
        } else if (isSelected) {
            color1 = -16777216;
        }
        return color1;
    }

    protected final int getDefaultColor2(boolean isSelected, boolean isMouseOver) {
        int color2 = -4802890;
        if (isMouseOver && isSelected) {
            color2 = -11842741;
        } else if (isMouseOver) {
            color2 = -4802890;
        } else if (isSelected) {
            color2 = -11842741;
        }
        return color2;
    }

    protected final int getDefaultTextColor(boolean isSelected, boolean isMouseOver) {
        int textColor = -16777216;
        if (isMouseOver && isSelected) {
            textColor = -256;
        } else if (isSelected) {
            textColor = -256;
        }
        return textColor;
    }
}

