/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control.listbox;

import com.google.common.collect.Lists;
import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ControlContainer;
import cubex2.cs3.ingame.gui.control.IValueListener;
import cubex2.cs3.ingame.gui.control.Slider;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.ingame.gui.control.builder.ControlBuilder;
import cubex2.cs3.ingame.gui.control.listbox.IListBoxItemClickListener;
import cubex2.cs3.ingame.gui.control.listbox.IListBoxItemProvider;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxItem;
import cubex2.cs3.util.Filter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ListBox<T>
extends ControlContainer
implements IValueListener<Slider> {
    public static final int HORIZONTAL_GAP = 1;
    public static final int VERTICAL_GAP = 1;
    private Slider slider;
    private ControlContainer scrollerWindow;
    private ControlContainer itemContainer;
    private TextBox tbSearch;
    private Comparator<T> comparator;
    private Filter<T> filter;
    private final List<T> allElements;
    private final List<T> elements;
    private final List<Integer> selectedIndices = Lists.newArrayList();
    private int currentScroll = 0;
    private final boolean multiSelect;
    private final boolean canSelect;
    private final boolean isSorted;
    private final int columns;
    private final int elementHeight;
    private final int elementWidth;
    private final int listBoxItemMeta;
    private IListBoxItemClickListener<T> itemClickListener;
    private IListBoxItemProvider itemProvider;
    private int mouseX = -1;
    private int mouseY = -1;

    public ListBox(ListBoxDescription<T> desc, int width, int height, Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(width, height, anchor, offsetX, offsetY, parent);
        this.multiSelect = desc.multiSelect;
        this.canSelect = desc.canSelect;
        this.isSorted = desc.sorted;
        this.columns = desc.columns;
        this.elementHeight = desc.elementHeight;
        this.elementWidth = desc.elementWidth;
        this.listBoxItemMeta = desc.listBoxItemMeta;
        this.comparator = desc.comparator;
        this.itemProvider = desc.itemProvider;
        this.allElements = Lists.newArrayList(desc.elements);
        this.elements = Lists.newArrayList(desc.elements);
        this.sortElements();
        if (desc.hasSearchBar) {
            this.filter = desc.filter;
            this.tbSearch = (TextBox)this.textBox().fillWidth(0).bottom(0).add();
        }
        this.slider = (Slider)this.verticalSlider(this.calculateTotalHeight()).top(0).bottom(desc.hasSearchBar ? 17 : 0).right(0).width(desc.sliderWidth).add();
        this.slider.setValueListener(this);
        this.slider.setWheelScrollEverywhere(true);
        this.slider.setWheelScrollStep(this.elementHeight + 1);
        this.scrollerWindow = (ControlContainer)this.container().at(0, 0).bottom(this.slider, 0, true).right(this.slider, 3).add();
        this.scrollerWindow.enableScissor = true;
        this.itemContainer = (ControlContainer)new ItemContainerBuilder(this, this.scrollerWindow).fill().add();
        this.createListBoxItems();
        if (this.rootControl instanceof IListBoxItemClickListener) {
            this.itemClickListener = (IListBoxItemClickListener)((Object)this.rootControl);
        }
    }

    private void sortElements() {
        if (this.isSorted) {
            if (this.comparator != null) {
                Collections.sort(this.elements, this.comparator);
            } else {
                Collections.sort(this.elements);
            }
        }
    }

    public void disableGlobalScrolling() {
        this.slider.setWheelScrollEverywhere(false);
        this.slider.setWheelScrollParent(true);
    }

    public TextBox getSearchBox() {
        return this.tbSearch;
    }

    private int elementWidth() {
        if (this.elementWidth == -1 && this.columns > 1) {
            return (this.itemContainer.getWidth() - (this.columns - 1) * 1) / this.columns;
        }
        return this.elementWidth;
    }

    private void createListBoxItems() {
        this.itemContainer.getControls().clear();
        for (int i = 0; i < this.elements.size(); ++i) {
            int elementX = (this.elementWidth() + 1) * (i % this.columns);
            int elementY = i / this.columns * (this.elementHeight + 1);
            Anchor anchor = new Anchor(elementX, -1, elementY, -1);
            anchor.controlLeft = this.itemContainer;
            anchor.controlTop = this.itemContainer;
            anchor.sameSideLeft = true;
            anchor.sameSideTop = true;
            if (this.elementWidth() == -1) {
                anchor.controlRight = this.itemContainer;
                anchor.sameSideRight = true;
                anchor.distanceLeft = 0;
                anchor.distanceRight = 0;
            }
            this.itemContainer.addControl(this.itemProvider.createListBoxItem(this.elements.get(i), i, this.listBoxItemMeta, this.elementWidth(), this.elementHeight, anchor, 0, 0, this.itemContainer));
        }
    }

    private int calculateTotalHeight() {
        int numRows = this.elements.size() / this.columns + (this.elements.size() % this.columns != 0 ? 1 : 0);
        return numRows * this.elementHeight + (numRows - 1) * 1;
    }

    public int getSelectedIndex() {
        return this.selectedIndices.size() != 0 ? this.selectedIndices.get(0) : -1;
    }

    public T getSelectedItem() {
        return this.getSelectedIndex() != -1 ? (T)this.elements.get(this.getSelectedIndex()) : null;
    }

    public List<Integer> getSelectedIndices() {
        return Collections.unmodifiableList(this.selectedIndices);
    }

    public List<T> getSelectedItems() {
        ArrayList items = Lists.newArrayList();
        for (Integer i : this.getSelectedIndices()) {
            items.add(this.elements.get(i));
        }
        return Collections.unmodifiableList(items);
    }

    public void removeSelection() {
        this.selectedIndices.clear();
        for (Control control : this.itemContainer.getControls()) {
            ((ListBoxItem)control).setSelected(false);
        }
    }

    public void updateElements(List<T> newElements) {
        this.updateElements(newElements, null, null);
    }

    public void updateElements(List<T> newElements, Filter<T> filter, String searchText) {
        this.elements.clear();
        this.elements.addAll(newElements);
        if (filter != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                try {
                    if (filter.matches(this.elements.get(i), searchText)) continue;
                    this.elements.remove(i--);
                    continue;
                }
                catch (Exception e) {
                    this.elements.remove(i--);
                }
            }
        } else {
            this.allElements.clear();
            this.allElements.addAll(newElements);
        }
        this.sortElements();
        this.selectedIndices.clear();
        this.createListBoxItems();
        this.onParentResized();
        this.slider.updateScroll();
    }

    public void select(T item) {
        if (this.elements.contains(item)) {
            for (int i = 0; i < this.elements.size(); ++i) {
                if (!this.elements.get(i).equals(item)) continue;
                this.select(i);
            }
        }
    }

    public void select(int index) {
        if (index < this.elements.size()) {
            if (!this.multiSelect) {
                this.selectedIndices.clear();
            }
            this.selectedIndices.add(index);
            for (Integer idx : this.selectedIndices) {
                ((ListBoxItem)this.itemContainer.getControls().get(idx)).setSelected(true);
            }
            Collections.sort(this.selectedIndices);
        }
    }

    public void select(List<T> items) {
        if (!this.multiSelect) {
            return;
        }
        for (T t : items) {
            this.select(t);
        }
    }

    private void setScroll(int value) {
        if (this.currentScroll != value) {
            this.currentScroll = value;
            this.itemContainer.offsetY = -this.currentScroll;
            this.onParentResized();
        }
    }

    @Override
    public void onParentResized() {
        super.onParentResized();
        this.slider.setMaxValue(this.calculateTotalHeight() - this.slider.getHeight());
    }

    @Override
    public void keyTyped(char c, int key) {
        if (this.tbSearch == null) {
            super.keyTyped(c, key);
        } else {
            String prev = this.tbSearch.getText();
            super.keyTyped(c, key);
            String now = this.tbSearch.getText();
            if (!prev.equals(now)) {
                this.updateElements(this.allElements, this.filter, now);
                this.rootControl.claimFocus(this.tbSearch);
            }
        }
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY, int button) {
        if (c instanceof ListBoxItem) {
            ListBoxItem lbItem = (ListBoxItem)c;
            if (this.canSelect) {
                if (button == 0 && !this.selectedIndices.contains(lbItem.index)) {
                    if (!this.multiSelect) {
                        this.selectedIndices.clear();
                        for (Control control : this.itemContainer.getControls()) {
                            ((ListBoxItem)control).setSelected(false);
                        }
                    }
                    this.selectedIndices.add(lbItem.index);
                    lbItem.setSelected(true);
                } else if (button == 1 && this.selectedIndices.contains(lbItem.index)) {
                    this.selectedIndices.remove((Object)lbItem.index);
                    lbItem.setSelected(false);
                }
                Collections.sort(this.selectedIndices);
            }
            if (this.itemClickListener != null) {
                this.itemClickListener.itemClicked(lbItem.value, this, button);
            }
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float renderTick) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        super.draw(mouseX, mouseY, renderTick);
    }

    @Override
    public void onValueChanged(Slider slider) {
        this.setScroll(slider.getValue());
    }

    private static final class ItemContainerBuilder<T>
    extends ControlBuilder<ItemContainer<T>> {
        private final ListBox<T> listBox;

        public ItemContainerBuilder(ListBox<T> listBox, ControlContainer c) {
            super(c);
            this.listBox = listBox;
        }

        @Override
        protected ItemContainer<T> newInstance() {
            return new ItemContainer<T>(this.listBox, this.width, this.height, this.anchor, this.offsetX, this.offsetY, this.container);
        }
    }

    private static final class ItemContainer<T>
    extends ControlContainer {
        private final ListBox<T> listBox;

        public ItemContainer(ListBox<T> listBox, int width, int height, Anchor anchor, int offsetX, int offsetY, Control parent) {
            super(width, height, anchor, offsetX, offsetY, parent);
            this.listBox = listBox;
        }

        @Override
        protected void controlClicked(Control c, int mouseX, int mouseY, int button) {
            this.listBox.controlClicked(c, mouseX, mouseY, button);
        }

        @Override
        protected int firstControl() {
            return ((ListBox)this.listBox).currentScroll / (((ListBox)this.listBox).elementHeight + 1) * ((ListBox)this.listBox).columns;
        }

        @Override
        protected int numControls() {
            return ((ListBox)this.listBox).scrollerWindow.getHeight() / ((ListBox)this.listBox).elementHeight * ((ListBox)this.listBox).columns + ((ListBox)this.listBox).columns;
        }

        @Override
        public boolean isMouseOverControl(int mouseX, int mouseY) {
            return ((ListBox)this.listBox).scrollerWindow.isMouseOverControl(mouseX, mouseY);
        }
    }
}

