/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control.builder;

import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ControlContainer;

public abstract class ControlBuilder<T extends Control> {
    public ControlContainer container;
    protected Anchor anchor = new Anchor();
    public int width = 0;
    public int height = 0;
    protected int offsetX = 0;
    protected int offsetY = 0;

    public ControlBuilder(ControlContainer c) {
        this.container = c;
    }

    public ControlBuilder<T> left(int distance) {
        return this.left(this.container, distance, true);
    }

    public ControlBuilder<T> left(Control c, int distance) {
        return this.left(c, distance, false);
    }

    public ControlBuilder<T> left(Control c, int distance, boolean anchorLeftSide) {
        this.anchor.distanceLeft = distance;
        this.anchor.controlLeft = c;
        this.anchor.sameSideLeft = anchorLeftSide;
        return this;
    }

    public ControlBuilder<T> right(int distance) {
        return this.right(this.container, distance, true);
    }

    public ControlBuilder<T> right(Control c, int distance) {
        return this.right(c, distance, false);
    }

    public ControlBuilder<T> right(Control c, int distance, boolean anchorRightSide) {
        this.anchor.distanceRight = distance;
        this.anchor.controlRight = c;
        this.anchor.sameSideRight = anchorRightSide;
        return this;
    }

    public ControlBuilder<T> top(int distance) {
        return this.top(this.container, distance, true);
    }

    public ControlBuilder<T> top(Control c, int distance) {
        return this.top(c, distance, false);
    }

    public ControlBuilder<T> top(Control c, int distance, boolean anchorTopSide) {
        this.anchor.distanceTop = distance;
        this.anchor.controlTop = c;
        this.anchor.sameSideTop = anchorTopSide;
        return this;
    }

    public ControlBuilder<T> bottom(int distance) {
        return this.bottom(this.container, distance, true);
    }

    public ControlBuilder<T> bottom(Control c, int distance) {
        return this.bottom(c, distance, false);
    }

    public ControlBuilder<T> bottom(Control c, int distance, boolean anchorBottomSide) {
        this.anchor.distanceBottom = distance;
        this.anchor.controlBottom = c;
        this.anchor.sameSideBottom = anchorBottomSide;
        return this;
    }

    public ControlBuilder<T> below(Control c) {
        return this.below(c, 3);
    }

    public ControlBuilder<T> below(Control c, int gap) {
        return this.top(c, gap).left(c, 0, true);
    }

    public ControlBuilder<T> rightTo(Control c) {
        return this.rightTo(c, 3);
    }

    public ControlBuilder<T> rightTo(Control c, int gap) {
        return this.left(c, gap).top(c, 0, true);
    }

    public ControlBuilder<T> at(int x, int y) {
        return this.left(x).top(y);
    }

    public ControlBuilder<T> offset(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
        return this;
    }

    public ControlBuilder<T> centerHor() {
        return this.centerHor(0);
    }

    public ControlBuilder<T> centerHor(int offset) {
        this.anchor.controlLeft = this.container;
        this.anchor.controlRight = this.container;
        this.anchor.distanceLeft = 1;
        this.anchor.distanceRight = 1;
        this.offsetX = offset;
        return this;
    }

    public ControlBuilder<T> centerVert() {
        return this.centerVert(0);
    }

    public ControlBuilder<T> centerVert(int offset) {
        this.anchor.controlTop = this.container;
        this.anchor.controlBottom = this.container;
        this.anchor.sameSideTop = true;
        this.anchor.sameSideBottom = true;
        this.anchor.distanceTop = 1;
        this.anchor.distanceBottom = 1;
        this.offsetY = offset;
        return this;
    }

    public ControlBuilder<T> size(int w, int h) {
        this.width = w;
        this.height = h;
        return this;
    }

    public ControlBuilder<T> width(int w) {
        this.width = w;
        return this;
    }

    public ControlBuilder<T> fillWidth(int gap) {
        return this.left(gap).right(gap).width(-1);
    }

    public ControlBuilder<T> fill() {
        return this.left(0).right(0).top(0).bottom(0).size(-1, -1);
    }

    public ControlBuilder<T> height(int h) {
        this.height = h;
        return this;
    }

    public ControlBuilder<T> fillHeight(int gap) {
        return this.top(gap).bottom(gap).height(-1);
    }

    public T add() {
        T t = this.newInstance();
        this.container.addControl((Control)t);
        return t;
    }

    protected abstract T newInstance();
}

