/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control;

import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.IBlockDisplayRenderer;
import cubex2.cs3.util.GuiHelper;
import cubex2.cs3.util.MathUtil;
import cubex2.cs3.util.SimulatedWorld;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

public class WorldDisplay
extends Control {
    private RenderBlocks renderer = new RenderBlocks();
    private float rotation = 0.0f;
    public boolean rotate = true;
    public boolean canMoveAround = false;
    public float camX = 0.0f;
    public float camY = 5.0f;
    public float camZ = 2.0f;
    public float lookX = 0.0f;
    public float lookY = 0.0f;
    public float lookZ = 0.0f;
    public IBlockDisplayRenderer renderProvider;
    protected SimulatedWorld world;

    public WorldDisplay(SimulatedWorld world, int width, int height, Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(width, height, anchor, offsetX, offsetY, parent);
        this.setWorld(world);
    }

    public void setCam(float x, float y, float z) {
        this.camX = x;
        this.camY = y;
        this.camZ = z;
    }

    public void setLook(float x, float y, float z) {
        this.lookX = x;
        this.lookY = y;
        this.lookZ = z;
    }

    public void setWorld(SimulatedWorld world) {
        this.world = world;
        this.renderer.field_147845_a = world;
        this.renderer.func_147786_a(false);
        this.renderer.func_147753_b(false);
        this.renderer.field_147842_e = false;
    }

    @Override
    public void keyTyped(char c, int key) {
        if (!this.canMoveAround) {
            return;
        }
        float[] up = new float[]{0.0f, 1.0f, 0.0f};
        float[] forward = new float[]{this.lookX - this.camX, this.lookY - this.camY, this.lookZ - this.camZ};
        MathUtil.normalize(forward);
        float[] side = new float[3];
        MathUtil.cross(forward, up, side);
        MathUtil.normalize(side);
        if (key == 200 || key == 208) {
            MathUtil.scale(forward, 0.1f);
            int dir = key == 200 ? 1 : -1;
            this.lookX += forward[0] * (float)dir;
            this.lookY += forward[1] * (float)dir;
            this.lookZ += forward[2] * (float)dir;
            this.camX += forward[0] * (float)dir;
            this.camY += forward[1] * (float)dir;
            this.camZ += forward[2] * (float)dir;
        } else if (key == 205 || key == 203) {
            MathUtil.scale(side, 0.1f);
            int dir = key == 205 ? 1 : -1;
            this.lookX += side[0] * (float)dir;
            this.lookY += side[1] * (float)dir;
            this.lookZ += side[2] * (float)dir;
            this.camX += side[0] * (float)dir;
            this.camY += side[1] * (float)dir;
            this.camZ += side[2] * (float)dir;
        } else if (key == 32 || key == 30) {
            MathUtil.rotateY(forward, key == 30 ? 2.0f : -2.0f);
            this.lookX = this.camX + forward[0];
            this.lookY = this.camY + forward[1];
            this.lookZ = this.camZ + forward[2];
        } else if (key == 17 || key == 31) {
            MathUtil.rotateLine(forward, key == 31 ? -2.0f : 2.0f, side[0], side[1], side[2]);
            this.lookX = this.camX + forward[0];
            this.lookY = this.camY + forward[1];
            this.lookZ = this.camZ + forward[2];
        } else if (key == 209 || key == 201) {
            int dir = key == 209 ? -1 : 1;
            this.lookY += 0.1f * (float)dir;
            this.camY += 0.1f * (float)dir;
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float renderTick) {
        GuiHelper.drawRect(this.getBounds(), -16777216);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        ScaledResolution res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        GL11.glViewport((int)(this.getX() * res.func_78325_e()), (int)(this.mc.field_71440_d - this.getY() * res.func_78325_e() - this.getHeight() * res.func_78325_e()), (int)(this.getWidth() * res.func_78325_e()), (int)(this.getHeight() * res.func_78325_e()));
        Project.gluPerspective((float)70.0f, (float)((float)this.getWidth() / (float)this.getHeight()), (float)0.1f, (float)2000.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        Project.gluLookAt((float)this.camX, (float)this.camY, (float)this.camZ, (float)this.lookX, (float)this.lookY, (float)this.lookZ, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GL11.glRotatef((float)this.rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)32826);
        GL11.glClear((int)256);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        this.renderBlocks();
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glMatrixMode((int)5889);
        GL11.glViewport((int)0, (int)0, (int)this.mc.field_71443_c, (int)this.mc.field_71440_d);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
    }

    @Override
    public void onUpdate() {
        if (this.rotate) {
            this.rotation += 1.5f;
        }
    }

    private void renderBlocks() {
        this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
        this.renderer.func_147800_a(Blocks.field_150350_a, 0, 1.0f);
        GL11.glPopMatrix();
        if (this.renderProvider != null) {
            this.renderProvider.renderBlocks(this.renderer);
            return;
        }
        if (this.world != null) {
            Tessellator.field_78398_a.func_78382_b();
            RenderHelper.func_74520_c();
            for (int x = this.world.minX; x <= this.world.maxX; ++x) {
                for (int y = this.world.minY; y <= this.world.maxY; ++y) {
                    for (int z = this.world.minZ; z <= this.world.maxZ; ++z) {
                        Block block = this.world.func_147439_a(x, y, z);
                        if (block.func_149688_o() == Material.field_151579_a) continue;
                        this.renderer.func_147805_b(block, x, y, z);
                    }
                }
            }
            Tessellator.field_78398_a.func_78381_a();
        }
    }
}

