/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control;

import com.google.common.base.Predicate;
import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.IValidityControl;
import cubex2.cs3.ingame.gui.control.IValueListener;

public abstract class ValidityControl<T extends Control>
extends Control
implements IValidityControl {
    protected Predicate<T> validatorFunc = null;
    protected IValueListener valueChangedListener = null;

    public ValidityControl(int width, int height, Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(width, height, anchor, offsetX, offsetY, parent);
    }

    public void setValidatorFunc(Predicate<T> func) {
        this.validatorFunc = func;
        this.valueChanged();
    }

    @Override
    public boolean hasValidValue() {
        return this.validatorFunc == null || this.validatorFunc.apply((Object)this);
    }

    @Override
    public void setValueChangedListener(IValueListener listener) {
        this.valueChangedListener = listener;
        this.valueChanged();
    }

    protected void valueChanged() {
        if (this.valueChangedListener != null) {
            this.valueChangedListener.onValueChanged(this);
        }
    }
}

