/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control;

import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.ISelectElementCallback;
import cubex2.cs3.ingame.gui.common.WindowSelectTexture;
import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Button;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ControlContainer;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.util.ClientHelper;
import net.minecraft.util.ResourceLocation;

public class TextureTextBox
extends ControlContainer
implements ISelectElementCallback<String> {
    private final BaseContentPack pack;
    private final String subFolder;
    private TextBox tb;
    private Button btnDialog;
    private ResourceLocation location = null;
    private String prevText = null;

    public TextureTextBox(BaseContentPack pack, String subFolder, int width, Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(width, 14, anchor, offsetX, offsetY, parent);
        this.pack = pack;
        this.subFolder = subFolder;
        this.tb = (TextBox)this.textBox().height(-1).left(0).top(0).bottom(0).right(0).add();
        this.btnDialog = (Button)this.button("...").top(1).right(1).bottom(1).width(18).height(-1).add();
    }

    public void setText(String text) {
        this.tb.setText(text);
    }

    public String getText() {
        return this.tb.getText();
    }

    public void setMaxLength(int length) {
        this.tb.setMaxLength(length);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnDialog) {
            GuiBase.openWindow(new WindowSelectTexture(ClientHelper.getPackIcons(this.pack, this.subFolder), this));
        } else {
            super.controlClicked(c, mouseX, mouseY);
        }
    }

    @Override
    public void itemSelected(String element) {
        this.tb.setText(element);
    }

    public ResourceLocation getLocation() {
        String text = this.tb.getText().trim();
        if (this.location == null || this.prevText == null || !this.prevText.equals(text)) {
            String textureName;
            String modId = text.contains(":") ? text.split(":")[0] : this.pack.id.toLowerCase();
            String string = textureName = text.contains(":") && text.indexOf(58) != text.length() - 1 ? text.split(":")[1] : text;
            if (!textureName.endsWith(".png")) {
                textureName = textureName + ".png";
            }
            this.location = textureName.startsWith("textures/" + this.subFolder + "/") ? new ResourceLocation(modId + ":" + textureName) : new ResourceLocation(modId + ":textures/" + this.subFolder + "/" + textureName);
            this.prevText = text;
        }
        return this.location;
    }
}

