/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.util.GuiHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.MathHelper;
import org.lwjgl.util.Point;

public class TextField
extends Control {
    private static final int COMMENT_COLOR = -11842741;
    private static final int STRING_COLOR = -10516911;
    private static final int NUMBER_COLOR = -9922629;
    private static final int KEYWORD_COLOR = -5021651;
    private final FontRenderer fontRenderer;
    private boolean canLoseFocus = true;
    private boolean isFocused;
    private int horizonzalScroll = 0;
    private int verticalScroll = 0;
    private int linesToDisplay;
    private int colsToDisplay;
    private List<String> lines = Lists.newArrayList((Object[])new String[]{""});
    private final List<List<Integer>> colors = Lists.newArrayList();
    private boolean syntaxHighlighting = true;
    private boolean replaceMode = false;
    private int cursorX = 0;
    private int cursorY = 0;
    private int counter = 0;
    private int selectionEndX = -1;
    private int selectionEndY = -1;
    private static final String[] RESERVED_WORDS = new String[]{"break", "case", "catch", "continue", "debugger", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "true", "false"};

    public TextField(int width, int height, Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(width, height, anchor, offsetX, offsetY, parent);
        this.fontRenderer = this.mc.field_71466_p;
        this.linesToDisplay = this.getHeight() / 10;
        this.colsToDisplay = this.getWidth() / 6;
    }

    public void disableSyntaxHighlighting() {
        this.syntaxHighlighting = false;
    }

    public String getText() {
        return Joiner.on((char)'\n').join(this.lines);
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.setTextNoCursorReset(text);
        this.cursorX = 0;
        this.cursorY = 0;
        this.verticalScroll = 0;
        this.horizonzalScroll = 0;
    }

    private void setTextNoCursorReset(String text) {
        this.lines = Lists.newArrayList((Object[])text.split("\n"));
        this.textChanged();
    }

    public String getSelectedText() {
        if (this.selectionEndX == -1) {
            return "";
        }
        int selStartX = this.cursorX;
        int selStarY = this.cursorY;
        int selEndX = this.selectionEndX;
        int selEndY = this.selectionEndY;
        if (this.getOneDimPosition(this.cursorX, this.cursorY) > this.getOneDimPosition(this.selectionEndX, this.selectionEndY)) {
            selStartX = this.selectionEndX;
            selStarY = this.selectionEndY;
            selEndX = this.cursorX;
            selEndY = this.cursorY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < selEndY - selStarY + 1; ++i) {
            int startIdx = i == 0 ? selStartX : 0;
            int endIdx = i == selEndY - selStarY ? selEndX : this.lines.get(i + selStarY).length();
            sb.append(this.lines.get(i + selStarY).substring(startIdx, endIdx));
            if (i >= selEndY - selStarY) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    private void textChanged() {
        if (!this.syntaxHighlighting) {
            return;
        }
        boolean inMultiLineComment = false;
        boolean inQuotes = false;
        int quoteChar = 0;
        this.colors.clear();
        for (int i = 0; i < this.lines.size(); ++i) {
            this.colors.add(new ArrayList());
            for (int j = 0; j < this.lines.get(i).length(); ++j) {
                char nextChar;
                char c = this.lines.get(i).charAt(j);
                boolean isLastChar = j == this.lines.get(i).length() - 1;
                char c2 = nextChar = isLastChar ? (char)'\u0000' : this.lines.get(i).charAt(j + 1);
                if (inMultiLineComment) {
                    this.colors.get(i).add(-11842741);
                    if (c != '*' || isLastChar || nextChar != '/') continue;
                    this.colors.get(i).add(-11842741);
                    inMultiLineComment = false;
                    ++j;
                    continue;
                }
                boolean quoteStateChanged = false;
                if (c == '\"' && quoteChar != 39 || c == '\'' && quoteChar != 34) {
                    if (!inQuotes || inQuotes && this.numBackslashes(j, i) % 2 == 0) {
                        inQuotes = !inQuotes;
                        quoteStateChanged = true;
                    }
                    quoteChar = inQuotes ? c : (char)'\u0000';
                }
                if (!inQuotes) {
                    if (c == '/' && !isLastChar && nextChar == '*') {
                        this.colors.get(i).add(-11842741);
                        this.colors.get(i).add(-11842741);
                        inMultiLineComment = true;
                        ++j;
                        continue;
                    }
                    if (c == '/' && !isLastChar && nextChar == '/') {
                        do {
                            this.colors.get(i).add(-11842741);
                        } while (++j != this.lines.get(i).length());
                        break;
                    }
                    if (c == ',' || c == ';') {
                        this.colors.get(i).add(-5021651);
                        continue;
                    }
                    if (Character.isDigit(c) && (j == 0 || !Character.isJavaIdentifierPart(this.lines.get(i).charAt(j - 1)))) {
                        char c1;
                        do {
                            this.colors.get(i).add(-9922629);
                        } while (++j != this.lines.get(i).length() && (Character.isLetterOrDigit(c1 = this.lines.get(i).charAt(j)) || c1 == '.'));
                        --j;
                        continue;
                    }
                    int length = this.keyWordLength(i, j);
                    if (length != 0) {
                        for (int k = 0; k < length; ++k) {
                            this.colors.get(i).add(-5021651);
                            ++j;
                        }
                        --j;
                        continue;
                    }
                }
                this.colors.get(i).add(inQuotes || quoteStateChanged ? -10516911 : -1);
            }
            inQuotes = false;
        }
    }

    private int keyWordLength(int line, int pos) {
        int length = this.lines.get(line).length();
        for (String reservedWord : RESERVED_WORDS) {
            String wordInLine;
            if (pos + reservedWord.length() > length || !(wordInLine = this.lines.get(line).substring(pos, pos + reservedWord.length())).equals(reservedWord) || pos != 0 && Character.isJavaIdentifierPart(this.lines.get(line).charAt(pos - 1)) || pos + reservedWord.length() != length && Character.isJavaIdentifierPart(this.lines.get(line).charAt(pos + reservedWord.length()))) continue;
            return reservedWord.length();
        }
        return 0;
    }

    private int numBackslashes(int pos, int line) {
        for (int i = pos - 1; i >= 0; --i) {
            if (this.lines.get(line).charAt(i) == '\\') continue;
            return pos - 1 - i;
        }
        return 0;
    }

    private void deleteSelection() {
        int selStartX = this.cursorX;
        int selStarY = this.cursorY;
        int selEndX = this.selectionEndX;
        int selEndY = this.selectionEndY;
        if (this.getOneDimPosition(this.cursorX, this.cursorY) > this.getOneDimPosition(this.selectionEndX, this.selectionEndY)) {
            selStartX = this.selectionEndX;
            selStarY = this.selectionEndY;
            selEndX = this.cursorX;
            selEndY = this.cursorY;
        }
        String textBeforeSel = null;
        String textAfterSel = null;
        try {
            textBeforeSel = this.lines.get(selStarY).substring(0, selStartX);
            textAfterSel = this.lines.get(selEndY).substring(selEndX);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < selEndY - selStarY + 1; ++i) {
            this.lines.remove(selStarY);
        }
        this.lines.add(selStarY, textBeforeSel + textAfterSel);
        this.selectionEndX = -1;
        this.selectionEndY = -1;
        this.textChanged();
    }

    private void writeText(String s) {
        if (this.selectionEndX != -1) {
            this.deleteSelection();
            this.setCursorPosition(this.cursorX, this.cursorY);
        }
        if (s.equals("\n")) {
            String beforeNewLine = this.lines.get(this.cursorY).substring(0, this.cursorX);
            this.lines.set(this.cursorY, this.lines.get(this.cursorY).substring(this.cursorX));
            this.lines.add(this.cursorY, beforeNewLine);
            ++this.cursorY;
            this.cursorX = 0;
        } else {
            s = this.filterAllowedCharacters(s);
            String prev = this.lines.get(this.cursorY);
            this.lines.set(this.cursorY, prev.substring(0, this.cursorX) + s + prev.substring(this.replaceMode && this.cursorX < this.lines.get(this.cursorY).length() ? this.cursorX + 1 : this.cursorX, prev.length()));
            this.cursorX += s.length();
        }
        this.scrollToCursor();
        this.textChanged();
    }

    private String filterAllowedCharacters(String s) {
        StringBuilder stringbuilder = new StringBuilder();
        for (char c0 : s.toCharArray()) {
            if (c0 != '\u00a7' && !ChatAllowedCharacters.func_71566_a((char)c0)) continue;
            stringbuilder.append(c0);
        }
        return stringbuilder.toString();
    }

    private Point getLeftWordPosition() {
        int x;
        if (this.cursorX == 0 && this.cursorY == 0) {
            return new Point(0, 0);
        }
        int y = this.cursorY;
        if (x == 0) {
            while (y > 0 && this.lines.get(--y).length() == 0) {
            }
            x = this.lines.get(y).length();
        } else {
            for (x = this.cursorX; x > 0 && this.lines.get(y).charAt(x - 1) == ' '; --x) {
            }
            boolean passedNonWhiteSpace = false;
            while (x > 0 && this.lines.get(y).charAt(x - 1) != ' ') {
                passedNonWhiteSpace = true;
                --x;
            }
            if (x == 0 && !passedNonWhiteSpace) {
                while (this.lines.get(--y).length() == 0) {
                }
                x = this.lines.get(y).length();
            }
        }
        return new Point(x, y);
    }

    private Point getRightWordPosition() {
        if (this.cursorY == this.lines.size() - 1 && this.cursorX == this.lines.get(this.cursorY).length()) {
            return new Point(this.cursorX, this.cursorY);
        }
        int x = this.cursorX;
        int y = this.cursorY;
        if (x == this.lines.get(y).length()) {
            while (y < this.lines.size() - 1 && this.lines.get(++y).length() == 0) {
            }
            x = 0;
        }
        int lineLength = this.lines.get(y).length();
        x = this.lines.get(y).indexOf(32, x);
        if (x == -1) {
            x = lineLength;
        } else {
            while (x < lineLength && this.lines.get(y).charAt(x) == ' ') {
                ++x;
            }
        }
        return new Point(x, y);
    }

    private int getOneDimPosition(int x, int y) {
        int pos = 0;
        for (int i = 0; i < y; ++i) {
            pos += this.lines.get(i).length() + 1;
        }
        return pos += x;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button, boolean intoControl) {
        if (intoControl) {
            this.isFocused = true;
            int relX = mouseX - this.getX() - 2;
            int relY = mouseY - this.getY() - 2;
            this.setCursorPosition(relX / 6 + this.horizonzalScroll, relY / 9 + this.verticalScroll);
        } else if (this.canLoseFocus) {
            this.isFocused = false;
        }
    }

    @Override
    public void keyTyped(char c, int key) {
        if (this.isFocused) {
            switch (key) {
                case 203: {
                    if (GuiScreen.func_146271_m()) {
                        Point p = this.getLeftWordPosition();
                        this.setCursorPosition(p.getX(), p.getY());
                        break;
                    }
                    int newX = this.cursorX - 1;
                    int newY = this.cursorY;
                    if (newX < 0) {
                        if (this.cursorY == 0) {
                            newX = 0;
                        } else {
                            newX = Integer.MAX_VALUE;
                            --newY;
                        }
                    }
                    this.setCursorPosition(newX, newY);
                    break;
                }
                case 205: {
                    if (GuiScreen.func_146271_m()) {
                        Point p = this.getRightWordPosition();
                        this.setCursorPosition(p.getX(), p.getY());
                        break;
                    }
                    int newX = this.cursorX + 1;
                    int newY = this.cursorY;
                    if (newX > this.lines.get(this.cursorY).length()) {
                        if (this.cursorY == this.lines.size() - 1) {
                            --newX;
                        } else {
                            newX = 0;
                            ++newY;
                        }
                    }
                    this.setCursorPosition(newX, newY);
                    break;
                }
                case 200: {
                    int newX = this.cursorY == 0 ? 0 : this.cursorX;
                    int newY = this.cursorY - 1;
                    this.setCursorPosition(newX, newY);
                    break;
                }
                case 208: {
                    int newX = this.cursorY == this.lines.size() - 1 ? this.lines.get(this.cursorY).length() : this.cursorX;
                    int newY = this.cursorY + 1;
                    this.setCursorPosition(newX, newY);
                    break;
                }
                case 207: {
                    int newX = GuiScreen.func_146271_m() ? Integer.MAX_VALUE : this.lines.get(this.cursorY).length();
                    int newY = GuiScreen.func_146271_m() ? Integer.MAX_VALUE : this.cursorY;
                    this.setCursorPosition(newX, newY);
                    break;
                }
                case 199: {
                    int newX = 0;
                    int newY = GuiScreen.func_146271_m() ? 0 : this.cursorY;
                    this.setCursorPosition(newX, newY);
                    break;
                }
                case 201: {
                    int newX = this.cursorY == 0 ? 0 : this.cursorX;
                    int newY = this.cursorY - this.linesToDisplay + 1;
                    int prevScroll = this.verticalScroll;
                    this.setCursorPosition(newX, newY);
                    this.verticalScroll = Math.max(0, prevScroll - this.linesToDisplay + 1);
                    break;
                }
                case 209: {
                    int newX = this.cursorY == this.lines.size() - 1 ? this.lines.get(this.cursorY).length() : this.cursorY;
                    int newY = this.cursorY + this.linesToDisplay - 1;
                    this.setCursorPosition(newX, newY);
                    this.verticalScroll = Math.min(this.cursorY, this.lines.size() - this.linesToDisplay);
                    break;
                }
                case 28: {
                    this.writeText("\n");
                    break;
                }
                case 14: {
                    if (this.selectionEndX != -1) {
                        this.deleteSelection();
                        break;
                    }
                    if (this.cursorX == 0 && this.cursorY != 0) {
                        String newLine = this.lines.get(this.cursorY - 1) + this.lines.get(this.cursorY);
                        this.lines.remove(this.cursorY);
                        this.lines.set(this.cursorY - 1, newLine);
                        this.setCursorPosition(Integer.MAX_VALUE, this.cursorY - 1);
                        this.textChanged();
                    } else if (this.cursorX > 0) {
                        String currentLine = this.lines.get(this.cursorY);
                        this.lines.set(this.cursorY, currentLine.substring(0, this.cursorX - 1) + currentLine.substring(this.cursorX));
                        this.setCursorPosition(this.cursorX - 1, this.cursorY);
                        this.textChanged();
                    }
                    if (this.cursorX != this.horizonzalScroll || this.horizonzalScroll <= 0) break;
                    --this.horizonzalScroll;
                    break;
                }
                case 211: {
                    if (this.selectionEndX != -1) {
                        int selStartX = this.cursorX;
                        int selStarY = this.cursorY;
                        if (this.getOneDimPosition(this.cursorX, this.cursorY) > this.getOneDimPosition(this.selectionEndX, this.selectionEndY)) {
                            selStartX = this.selectionEndX;
                            selStarY = this.selectionEndY;
                        }
                        this.deleteSelection();
                        this.setCursorPosition(selStartX, selStarY);
                        break;
                    }
                    if (this.cursorX == this.lines.get(this.cursorY).length() && this.cursorY != this.lines.size() - 1) {
                        String newLine = this.lines.get(this.cursorY) + this.lines.get(this.cursorY + 1);
                        this.lines.remove(this.cursorY);
                        this.lines.set(this.cursorY, newLine);
                        this.setCursorPosition(this.cursorX, this.cursorY);
                        this.textChanged();
                        break;
                    }
                    if (this.cursorX >= this.lines.get(this.cursorY).length()) break;
                    String currentLine = this.lines.get(this.cursorY);
                    this.lines.set(this.cursorY, currentLine.substring(0, this.cursorX) + currentLine.substring(this.cursorX + 1));
                    this.textChanged();
                    break;
                }
                case 210: {
                    this.replaceMode = !this.replaceMode;
                    break;
                }
                default: {
                    if (key == 30 && GuiScreen.func_146271_m()) {
                        this.cursorX = 0;
                        this.cursorY = 0;
                        this.selectionEndY = this.lines.size() - 1;
                        this.selectionEndX = this.lines.get(this.selectionEndY).length();
                        break;
                    }
                    if (key == 47 && GuiScreen.func_146271_m()) {
                        String text = GuiScreen.func_146277_j();
                        String[] split = text.split("\n");
                        for (int i = 0; i < split.length; ++i) {
                            this.writeText(split[i]);
                            if (i >= split.length - 1) continue;
                            this.writeText("\n");
                        }
                        break;
                    }
                    if (key == 46 && GuiScreen.func_146271_m()) {
                        GuiScreen.func_146275_d((String)this.getSelectedText());
                        break;
                    }
                    if (c != '\u00a7' && !ChatAllowedCharacters.func_71566_a((char)c)) break;
                    this.writeText(String.valueOf(c));
                }
            }
            this.scrollToCursor();
        }
    }

    private void scrollToCursor() {
        while (this.cursorX >= this.horizonzalScroll + this.colsToDisplay) {
            ++this.horizonzalScroll;
        }
        while (this.cursorX < this.horizonzalScroll) {
            --this.horizonzalScroll;
        }
        while (this.cursorY >= this.verticalScroll + this.linesToDisplay) {
            ++this.verticalScroll;
        }
        while (this.cursorY < this.verticalScroll) {
            --this.verticalScroll;
        }
    }

    private void setCursorPosition(int x, int y) {
        int prevX = this.cursorX;
        int prevY = this.cursorY;
        y = MathHelper.func_76125_a((int)y, (int)0, (int)(this.lines.size() - 1));
        this.cursorX = x = MathHelper.func_76125_a((int)x, (int)0, (int)this.lines.get(y).length());
        this.cursorY = y;
        this.scrollToCursor();
        if (!GuiBase.func_146272_n()) {
            this.selectionEndX = -1;
            this.selectionEndY = -1;
        } else if (this.selectionEndX == -1) {
            this.selectionEndX = prevX;
            this.selectionEndY = prevY;
        }
    }

    @Override
    public void onUpdate() {
        ++this.counter;
        if (GuiBase.dWheel != 0) {
            int maxVertScroll = Math.max(0, this.lines.size() - this.linesToDisplay);
            this.verticalScroll = MathHelper.func_76125_a((int)(this.verticalScroll - GuiBase.dWheel), (int)0, (int)maxVertScroll);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float renderTick) {
        int row;
        GuiHelper.drawRect(this.bounds, -16777216);
        int oneDimCursor = this.getOneDimPosition(this.cursorX, this.cursorY);
        int oneDimSelection = this.getOneDimPosition(this.selectionEndX, this.selectionEndY);
        int selStart = this.selectionEndX == -1 ? -1 : Math.min(oneDimCursor, oneDimSelection);
        int selEnd = this.selectionEndX == -1 ? -1 : Math.max(oneDimCursor, oneDimSelection);
        for (int i = 0; i < this.linesToDisplay && (row = i + this.verticalScroll) < this.lines.size(); ++i) {
            int col;
            for (int j = 0; j < this.colsToDisplay && (col = j + this.horizonzalScroll) < this.lines.get(row).length(); ++j) {
                int color;
                char c = this.lines.get(row).charAt(col);
                int charWidth = this.fontRenderer.func_78263_a(c);
                int charOffset = (6 - charWidth) / 2;
                int pos = this.getOneDimPosition(col, row);
                int n = color = this.syntaxHighlighting ? this.colors.get(row).get(col) : -1;
                if (pos >= selStart && pos < selEnd) {
                    GuiHelper.drawRect(this.getX() + 2 + j * 6 - 1, this.getY() + 2 + i * 9, this.getX() + 2 + j * 6 + 6, this.getY() + 2 + i * 9 + 8, -16776961);
                }
                this.fontRenderer.func_78276_b(String.valueOf(c), this.getX() + 2 + j * 6 + charOffset, this.getY() + 2 + i * 9, color);
            }
        }
        if (this.isFocused && this.counter % 20 < 10 && this.cursorY >= this.verticalScroll && this.cursorY < this.verticalScroll + this.linesToDisplay) {
            int y1;
            int x1;
            if (!this.replaceMode && this.cursorY < this.lines.size() && this.cursorX < this.lines.get(this.cursorY).length()) {
                x1 = this.getX() + 2 + (this.cursorX - this.horizonzalScroll) * 6;
                y1 = this.getY() + 1 + (this.cursorY - this.verticalScroll) * 9;
                GuiHelper.drawRect(x1, y1, x1 + 1, y1 + 10, -1);
            } else {
                x1 = this.getX() + 2 + (this.cursorX - this.horizonzalScroll) * 6;
                y1 = this.getY() + 2 + (this.cursorY - this.verticalScroll) * 9 + 8;
                GuiHelper.drawRect(x1, y1, x1 + 6, y1 + 1, -1);
            }
        }
    }
}

