/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control;

import com.google.common.collect.Lists;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.IValidityControl;
import cubex2.cs3.ingame.gui.control.IValidityProvider;
import cubex2.cs3.ingame.gui.control.IValueListener;
import cubex2.cs3.lib.Textures;
import cubex2.cs3.util.GuiHelper;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;

public class TextBox
extends Control
implements IValidityControl {
    private IValidityProvider validityProvider;
    private IValueListener valueChangedListener;
    private String validityMessage;
    private boolean isValid = true;
    private Rectangle validityRect;
    private boolean numbersOnly = false;
    private int maxLength = Integer.MAX_VALUE;
    private String text = "";
    private int cursorCounter;
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;
    private int enabledColor = 0xE0E0E0;
    private int disabledColor = 0x707070;

    public TextBox(int width, int height, Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(width, height, anchor, offsetX, offsetY, parent);
        this.tabStop = true;
        this.validityRect = new Rectangle(this.bounds.getX() + this.bounds.getWidth() - 12, this.bounds.getY() + (this.bounds.getHeight() - 9) / 2, 9, 9);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        if (this.numbersOnly) {
            value = value.replaceAll("[\\D]", "");
        }
        this.text = value.length() > this.maxLength ? value.substring(0, this.maxLength) : value;
        this.setCursorPositionEnd();
        this.valueChanged();
    }

    public void setNumbersOnly(boolean numbersOnly) {
        this.numbersOnly = numbersOnly;
        this.setText(this.text);
    }

    @Override
    public boolean hasValidValue() {
        return this.isValid;
    }

    @Override
    public void setValueChangedListener(IValueListener listener) {
        this.valueChangedListener = listener;
        this.valueChanged();
    }

    public void setValidityProvider(IValidityProvider validityProvider) {
        this.validityProvider = validityProvider;
        this.valueChanged();
    }

    public void setMaxLength(int value) {
        this.maxLength = value;
    }

    @Override
    public void onParentResized() {
        super.onParentResized();
        this.validityRect = new Rectangle(this.bounds.getX() + this.bounds.getWidth() - 12, this.bounds.getY() + (this.bounds.getHeight() - 9) / 2, 9, 9);
    }

    @Override
    public void keyTyped(char c, int key) {
        if (!this.hasFocus()) {
            return;
        }
        block0 : switch (c) {
            case '\u0001': {
                this.setCursorPositionEnd();
                this.setSelectionPos(0);
                break;
            }
            case '\u0003': {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                break;
            }
            case '\u0016': {
                if (!this.isEnabled()) break;
                String s = GuiScreen.func_146277_j();
                if (this.numbersOnly) {
                    s = s.replaceAll("[\\D]", "");
                }
                this.writeText(s);
                break;
            }
            case '\u0018': {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                if (!this.isEnabled()) break;
                this.writeText("");
                break;
            }
            default: {
                switch (key) {
                    case 14: {
                        if (GuiScreen.func_146271_m()) {
                            if (!this.isEnabled()) break block0;
                            this.deleteWords(-1);
                            break block0;
                        }
                        if (!this.isEnabled()) break block0;
                        this.deleteFromCursor(-1);
                        break block0;
                    }
                    case 199: {
                        if (GuiScreen.func_146272_n()) {
                            this.setSelectionPos(0);
                            break block0;
                        }
                        this.setCursorPositionZero();
                        break block0;
                    }
                    case 203: {
                        if (GuiScreen.func_146272_n()) {
                            if (GuiScreen.func_146271_m()) {
                                this.setSelectionPos(this.getNthWordFromPos(-1, this.getSelectionEnd()));
                                break block0;
                            }
                            this.setSelectionPos(this.getSelectionEnd() - 1);
                            break block0;
                        }
                        if (GuiScreen.func_146271_m()) {
                            this.setCursorPosition(this.getNthWordFromCursor(-1));
                            break block0;
                        }
                        this.moveCursorBy(-1);
                        break block0;
                    }
                    case 205: {
                        if (GuiScreen.func_146272_n()) {
                            if (GuiScreen.func_146271_m()) {
                                this.setSelectionPos(this.getNthWordFromPos(1, this.getSelectionEnd()));
                                break block0;
                            }
                            this.setSelectionPos(this.getSelectionEnd() + 1);
                            break block0;
                        }
                        if (GuiScreen.func_146271_m()) {
                            this.setCursorPosition(this.getNthWordFromCursor(1));
                            break block0;
                        }
                        this.moveCursorBy(1);
                        break block0;
                    }
                    case 207: {
                        if (GuiScreen.func_146272_n()) {
                            this.setSelectionPos(this.text.length());
                            break block0;
                        }
                        this.setCursorPositionEnd();
                        break block0;
                    }
                    case 211: {
                        if (GuiScreen.func_146271_m()) {
                            if (!this.isEnabled()) break block0;
                            this.deleteWords(1);
                            break block0;
                        }
                        if (!this.isEnabled()) break block0;
                        this.deleteFromCursor(1);
                        break block0;
                    }
                    default: {
                        if (!ChatAllowedCharacters.func_71566_a((char)c) || this.numbersOnly && !Character.isDigit(c) || !this.isEnabled()) break block0;
                        this.writeText(Character.toString(c));
                    }
                }
            }
        }
        if (this.getText().length() > this.maxLength) {
            this.setText(this.getText().substring(0, this.getText().length() - 1));
        }
        if (this.numbersOnly && this.getText().matches(".*[\\D]+.*")) {
            this.setText(this.getText().replaceAll("[\\D]", ""));
        }
        this.valueChanged();
    }

    @Override
    public void mouseDown(int mouseX, int mouseY, int button) {
        this.rootControl.claimFocus(this);
        if (this.hasFocus() && button == 0) {
            int l = mouseX - this.getX() - 4;
            String s = this.mc.field_71466_p.func_78269_a(this.text.substring(this.lineScrollOffset), this.getWidth());
            this.setCursorPosition(this.mc.field_71466_p.func_78269_a(s, l).length() + this.lineScrollOffset);
        }
    }

    private void valueChanged() {
        if (this.validityProvider != null) {
            this.validityMessage = this.validityProvider.checkValidity(this);
            boolean bl = this.isValid = this.validityMessage == null;
        }
        if (this.valueChangedListener != null) {
            this.valueChangedListener.onValueChanged(this);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float renderTick) {
        if (!this.isValid) {
            this.mc.field_71446_o.func_110577_a(Textures.CONTROLS);
            this.zLevel += 10.0f;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect(this.validityRect.getX(), this.validityRect.getY(), 200, 72, this.validityRect.getWidth(), this.validityRect.getHeight());
            this.zLevel -= 10.0f;
        }
        GuiBase.func_73734_a((int)(this.getX() - 1), (int)(this.getY() - 1), (int)(this.getX() + this.getWidth() + 1), (int)(this.getY() + this.getHeight() + 1), (int)-6250336);
        GuiBase.func_73734_a((int)this.getX(), (int)this.getY(), (int)(this.getX() + this.getWidth()), (int)(this.getY() + this.getHeight()), (int)-16777216);
        int i = this.isEnabled() ? this.enabledColor : this.disabledColor;
        int j = this.cursorPosition - this.lineScrollOffset;
        int k = this.selectionEnd - this.lineScrollOffset;
        String s = this.mc.field_71466_p.func_78269_a(this.text.substring(this.lineScrollOffset), this.getWidth());
        boolean flag = j >= 0 && j <= s.length();
        boolean flag1 = this.hasFocus() && this.cursorCounter / 6 % 2 == 0 && flag;
        int l = this.getX() + 4;
        int i1 = this.getY() + (this.getHeight() - 8) / 2;
        int j1 = l;
        if (k > s.length()) {
            k = s.length();
        }
        if (s.length() > 0) {
            String s1 = flag ? s.substring(0, j) : s;
            j1 = this.mc.field_71466_p.func_78261_a(s1, l, i1, i);
        }
        boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.maxLength;
        int k1 = j1;
        if (!flag) {
            k1 = j > 0 ? l + this.getWidth() : l;
        } else if (flag2) {
            k1 = j1 - 1;
            --j1;
        }
        if (s.length() > 0 && flag && j < s.length()) {
            this.mc.field_71466_p.func_78261_a(s.substring(j), j1, i1, i);
        }
        if (flag1) {
            if (flag2) {
                Gui.func_73734_a((int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + this.mc.field_71466_p.field_78288_b), (int)-3092272);
            } else {
                this.mc.field_71466_p.func_78261_a("_", k1, i1, i);
            }
        }
        if (k != j) {
            int l1 = l + this.mc.field_71466_p.func_78256_a(s.substring(0, k));
            this.drawCursorVertical(k1, i1 - 1, l1 - 1, i1 + 1 + this.mc.field_71466_p.field_78288_b);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (!this.isValid && this.validityRect.contains(mouseX, mouseY)) {
            GuiHelper.drawHoveringText(Lists.newArrayList((Object[])new String[]{this.validityMessage}), mouseX, mouseY, this.mc.field_71466_p);
        }
    }

    public String getSelectedText() {
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.text.substring(i, j);
    }

    public void writeText(String p_146191_1_) {
        int l;
        String s1 = "";
        String s2 = ChatAllowedCharacters.func_71565_a((String)p_146191_1_);
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.maxLength - this.text.length() - (i - this.selectionEnd);
        boolean flag = false;
        if (this.text.length() > 0) {
            s1 = s1 + this.text.substring(0, i);
        }
        if (k < s2.length()) {
            s1 = s1 + s2.substring(0, k);
            l = k;
        } else {
            s1 = s1 + s2;
            l = s2.length();
        }
        if (this.text.length() > 0 && j < this.text.length()) {
            s1 = s1 + this.text.substring(j);
        }
        this.text = s1;
        this.moveCursorBy(i - this.selectionEnd + l);
    }

    public void deleteWords(int p_146177_1_) {
        if (this.text.length() != 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(p_146177_1_) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int p_146175_1_) {
        if (this.text.length() != 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean flag = p_146175_1_ < 0;
                int j = flag ? this.cursorPosition + p_146175_1_ : this.cursorPosition;
                int k = flag ? this.cursorPosition : this.cursorPosition + p_146175_1_;
                String s = "";
                if (j >= 0) {
                    s = this.text.substring(0, j);
                }
                if (k < this.text.length()) {
                    s = s + this.text.substring(k);
                }
                this.text = s;
                if (flag) {
                    this.moveCursorBy(p_146175_1_);
                }
            }
        }
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public int getNthWordFromCursor(int p_146187_1_) {
        return this.getNthWordFromPos(p_146187_1_, this.getCursorPosition());
    }

    public int getNthWordFromPos(int p_146183_1_, int p_146183_2_) {
        return this.func_146197_a(p_146183_1_, this.getCursorPosition(), true);
    }

    public int func_146197_a(int p_146197_1_, int p_146197_2_, boolean p_146197_3_) {
        int k = p_146197_2_;
        boolean flag1 = p_146197_1_ < 0;
        int l = Math.abs(p_146197_1_);
        for (int i1 = 0; i1 < l; ++i1) {
            if (flag1) {
                while (p_146197_3_ && k > 0 && this.text.charAt(k - 1) == ' ') {
                    --k;
                }
                while (k > 0 && this.text.charAt(k - 1) != ' ') {
                    --k;
                }
                continue;
            }
            int j1 = this.text.length();
            if ((k = this.text.indexOf(32, k)) == -1) {
                k = j1;
                continue;
            }
            while (p_146197_3_ && k < j1 && this.text.charAt(k) == ' ') {
                ++k;
            }
        }
        return k;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public void moveCursorBy(int p_146182_1_) {
        this.setCursorPosition(this.selectionEnd + p_146182_1_);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    public void setCursorPosition(int p_146190_1_) {
        this.cursorPosition = p_146190_1_;
        int j = this.text.length();
        if (this.cursorPosition < 0) {
            this.cursorPosition = 0;
        }
        if (this.cursorPosition > j) {
            this.cursorPosition = j;
        }
        this.setSelectionPos(this.cursorPosition);
    }

    public void setSelectionPos(int position) {
        int j = this.text.length();
        if (position > j) {
            position = j;
        }
        if (position < 0) {
            position = 0;
        }
        this.selectionEnd = position;
        if (this.mc.field_71466_p != null) {
            if (this.lineScrollOffset > j) {
                this.lineScrollOffset = j;
            }
            int k = this.getWidth();
            String s = this.mc.field_71466_p.func_78269_a(this.text.substring(this.lineScrollOffset), k);
            int l = s.length() + this.lineScrollOffset;
            if (position == this.lineScrollOffset) {
                this.lineScrollOffset -= this.mc.field_71466_p.func_78262_a(this.text, k, true).length();
            }
            if (position > l) {
                this.lineScrollOffset += position - l;
            } else if (position <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - position;
            }
            if (this.lineScrollOffset < 0) {
                this.lineScrollOffset = 0;
            }
            if (this.lineScrollOffset > j) {
                this.lineScrollOffset = j;
            }
        }
    }

    private void drawCursorVertical(int p_146188_1_, int p_146188_2_, int p_146188_3_, int p_146188_4_) {
        int i1;
        if (p_146188_1_ < p_146188_3_) {
            i1 = p_146188_1_;
            p_146188_1_ = p_146188_3_;
            p_146188_3_ = i1;
        }
        if (p_146188_2_ < p_146188_4_) {
            i1 = p_146188_2_;
            p_146188_2_ = p_146188_4_;
            p_146188_4_ = i1;
        }
        if (p_146188_3_ > this.getX() + this.getWidth()) {
            p_146188_3_ = this.getX() + this.getWidth();
        }
        if (p_146188_1_ > this.getX() + this.getWidth()) {
            p_146188_1_ = this.getX() + this.getWidth();
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)p_146188_1_, (double)p_146188_4_, 0.0);
        tessellator.func_78377_a((double)p_146188_3_, (double)p_146188_4_, 0.0);
        tessellator.func_78377_a((double)p_146188_3_, (double)p_146188_2_, 0.0);
        tessellator.func_78377_a((double)p_146188_1_, (double)p_146188_2_, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3058);
        GL11.glEnable((int)3553);
    }
}

