/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control;

import com.google.common.collect.Lists;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.Tab;
import cubex2.cs3.ingame.gui.control.TabChangedListener;
import cubex2.cs3.lib.Textures;
import java.util.List;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class TabControl
extends Control {
    private static final int SCROLL_BUTTON_HEIGHT = 10;
    private List<Tab> tabs = Lists.newArrayList();
    private Tab activeTab = null;
    private int tabWidth;
    private int tabHeight;
    private int maxPossibleTabs;
    private int scroll = 0;
    private int maxScroll;
    public TabChangedListener listener;

    public TabControl(int tabWidth, int tabHeight, int width, int height, Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(width, height, anchor, offsetX, offsetY, parent);
        this.tabWidth = tabWidth;
        this.tabHeight = tabHeight;
        this.maxPossibleTabs = this.bounds.getHeight() / tabHeight;
        this.maxScroll = this.tabs.size() - this.maxPossibleTabs;
    }

    public Tab addTab(String title) {
        Anchor anchor = new Anchor(0, 0, 0, 0);
        anchor.controlLeft = this;
        anchor.controlRight = this;
        anchor.controlTop = this;
        anchor.controlBottom = this;
        anchor.sameSideLeft = true;
        anchor.sameSideRight = true;
        anchor.sameSideTop = true;
        anchor.sameSideBottom = true;
        Tab tab = new Tab(title, -1, -1, anchor, 0, 0, this);
        this.tabs.add(tab);
        if (this.activeTab == null) {
            this.activeTab = tab;
        }
        this.maxScroll = Math.max(this.tabs.size() - this.maxPossibleTabs, 0);
        return tab;
    }

    @Override
    public void onParentResized() {
        super.onParentResized();
        for (int i = 0; i < this.tabs.size(); ++i) {
            this.tabs.get(i).onParentResized();
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button, boolean intoControl) {
        if (mouseX >= this.getX() - this.tabWidth && mouseX < this.getX() && mouseY >= this.getY() && mouseY < this.getY() + this.getHeight()) {
            int clickedTab = (mouseY - this.getY()) / this.tabHeight + this.scroll;
            if (clickedTab < this.tabs.size()) {
                this.activeTab = this.tabs.get(clickedTab);
                if (this.listener != null) {
                    this.listener.tabChanged(this, this.activeTab);
                }
            }
        } else if (mouseX >= this.getX() - this.tabWidth / 2 - 4 && mouseX < this.getX() - this.tabWidth / 2 + 15 && mouseY >= this.getY() - 10 && mouseY < this.getY() && this.scroll > 0) {
            --this.scroll;
        } else if (mouseX >= this.getX() - this.tabWidth / 2 - 4 && mouseX < this.getX() - this.tabWidth / 2 + 15 && mouseY >= this.getY() + this.getHeight() && mouseY < this.getY() + this.getHeight() + 10 && this.scroll < this.maxScroll) {
            ++this.scroll;
        } else if (this.activeTab != null) {
            this.activeTab.mouseClicked(mouseX, mouseY, button, intoControl);
        }
    }

    @Override
    public void mouseDown(int mouseX, int mouseY, int button) {
        if (this.activeTab != null) {
            this.activeTab.mouseDown(mouseX, mouseY, button);
        }
    }

    @Override
    public void mouseUp(int mouseX, int mouseY, int button) {
        if (this.activeTab != null) {
            this.activeTab.mouseUp(mouseX, mouseY, button);
        }
    }

    @Override
    public void keyTyped(char c, int key) {
        if (this.activeTab != null) {
            this.activeTab.keyTyped(c, key);
        }
    }

    @Override
    public void onUpdate() {
        if (this.activeTab != null) {
            this.activeTab.onUpdate();
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float renderTick) {
        int y;
        int x;
        Tab tab;
        int idx;
        int i;
        int wheel = GuiBase.dWheel;
        if (wheel != 0 && mouseX >= this.getX() - this.tabWidth && mouseX < this.getX() && mouseY >= this.getY() && mouseY < this.getY() + this.getHeight()) {
            this.scroll = MathHelper.func_76125_a((int)(this.scroll - wheel), (int)0, (int)this.maxScroll);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.field_71446_o.func_110577_a(Textures.CONTROLS2);
        if (this.tabs.size() > this.maxPossibleTabs) {
            this.drawScrollButton(-10, mouseX, mouseY, 180, this.scroll > 0);
            this.drawScrollButton(this.getHeight(), mouseX, mouseY, 191, this.scroll < this.maxScroll);
        }
        for (i = 0; i < this.maxPossibleTabs && (idx = i + this.scroll) < this.tabs.size(); ++i) {
            tab = this.tabs.get(idx);
            x = this.getX() - this.tabWidth + 4;
            y = this.getY() + i * this.tabHeight;
            int u = 0;
            int v = (tab == this.activeTab ? 0 : 90) + (i == 0 ? 0 : (i == this.maxPossibleTabs - 1 ? 60 : 30));
            this.drawTexturedModalRect(x, y, u, v, this.tabWidth / 2, this.tabHeight / 2);
            this.drawTexturedModalRect(x + this.tabWidth / 2, y, 100 - this.tabWidth / 2, v, this.tabWidth / 2, this.tabHeight / 2);
            this.drawTexturedModalRect(x, y + this.tabHeight / 2, 0, 30 - this.tabHeight / 2 + v, this.tabWidth / 2, this.tabHeight / 2);
            this.drawTexturedModalRect(x + this.tabWidth / 2, y + this.tabHeight / 2, 100 - this.tabWidth / 2, 30 - this.tabHeight / 2 + v, this.tabWidth / 2, this.tabHeight / 2);
        }
        for (i = 0; i < this.maxPossibleTabs && (idx = i + this.scroll) < this.tabs.size(); ++i) {
            tab = this.tabs.get(idx);
            x = this.getX() - this.tabWidth + 9;
            y = this.getY() + i * this.tabHeight + (this.tabHeight - 9) / 2 + 1;
            this.mc.field_71466_p.func_78276_b(tab.title, x, y, tab == this.activeTab ? -16777216 : 0x404040);
        }
        if (this.activeTab != null) {
            this.activeTab.draw(mouseX, mouseY, renderTick);
        }
    }

    private void drawScrollButton(int yOffset, int mouseX, int mouseY, int v, boolean enabled) {
        boolean hover;
        int x = this.getX() - this.tabWidth / 2 - 4;
        int y = this.getY() + yOffset;
        boolean bl = hover = mouseX >= x && mouseX < x + 19 && mouseY >= y && mouseY < y + 10;
        int u = enabled ? (hover ? 0 : 19) : 38;
        this.drawTexturedModalRect(x, y, u, v, 19, 10);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (this.activeTab != null) {
            this.activeTab.drawForeground(mouseX, mouseY);
        }
    }
}

