/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control;

import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.IValueListener;
import cubex2.cs3.util.GuiHelper;
import net.minecraft.util.MathHelper;
import org.lwjgl.util.Rectangle;

public class Slider
extends Control {
    private final Direction direction;
    protected Rectangle scrollThumbRect;
    protected int mousePos = -1;
    protected boolean mouseDown = false;
    protected int scrollOffset;
    protected int prevScrollOffset = -1;
    private int wheelScrollStep = 1;
    private boolean wheelScrollEverywhere = false;
    private boolean wheelScrollParent = false;
    private int currentValue;
    protected int maxValue;
    private int thumbSize;
    private IValueListener<Slider> listener;
    private int mouseX = -1;
    private int mouseY = -1;

    public Slider(Direction direction, int maxValue, int width, int height, Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(width, height, anchor, offsetX, offsetY, parent);
        this.direction = direction;
        this.maxValue = maxValue;
        this.updateThumbSize();
        this.scrollThumbRect = new Rectangle(this.getX(), this.getY(), this.thumbWidth(), this.thumbHeight());
        if (this.rootControl instanceof IValueListener) {
            this.listener = this.rootControl;
        }
    }

    private int scrollAreaSize() {
        return this.direction == Direction.HORIZONTAL ? this.getWidth() : this.getHeight();
    }

    private int thumbWidth() {
        return this.direction == Direction.HORIZONTAL ? this.thumbSize : this.getWidth();
    }

    private int thumbHeight() {
        return this.direction == Direction.VERTICAL ? this.thumbSize : this.getHeight();
    }

    private int maxScrollSize() {
        return (this.direction == Direction.HORIZONTAL ? this.getWidth() : this.getHeight()) - this.thumbSize;
    }

    private void updateThumbRect() {
        if (this.direction == Direction.HORIZONTAL) {
            this.scrollThumbRect.setX(this.getX() + this.scrollOffset);
        } else {
            this.scrollThumbRect.setY(this.getY() + this.scrollOffset);
        }
    }

    public void setValueListener(IValueListener<Slider> listener) {
        this.listener = listener;
    }

    public int getValue() {
        return this.currentValue;
    }

    public float getValueFloat() {
        return (float)this.scrollOffset / (float)this.maxScrollSize() * (float)this.maxValue;
    }

    public void setWheelScrollStep(int value) {
        this.wheelScrollStep = value;
    }

    public void setWheelScrollEverywhere(boolean value) {
        this.wheelScrollEverywhere = value;
    }

    public void setWheelScrollParent(boolean value) {
        this.wheelScrollParent = value;
    }

    public void setMaxValue(int value) {
        this.maxValue = value;
        this.updateThumbSize();
        this.scrollThumbRect.setHeight(this.thumbSize);
        this.currentValue = Math.min(this.currentValue, this.maxValue);
        this.scrollOffset = (int)((float)this.maxScrollSize() / (float)this.maxValue * (float)this.currentValue);
        this.updateThumbRect();
    }

    private void updateThumbSize() {
        int total = this.scrollAreaSize() + this.maxValue;
        float perc = (float)this.scrollAreaSize() / (float)total;
        this.thumbSize = this.maxValue <= 0 ? 0 : Math.max((int)(perc * (float)this.scrollAreaSize()), 10);
    }

    @Override
    public void onParentResized() {
        super.onParentResized();
        this.scrollThumbRect = new Rectangle(this.getX(), this.getY(), this.thumbWidth(), this.thumbHeight());
        this.updateThumbRect();
    }

    @Override
    public void mouseDown(int mouseX, int mouseY, int button) {
        if (button == 0 && this.maxValue > 0) {
            this.mouseDown = true;
            if (!this.scrollThumbRect.contains(mouseX, mouseY)) {
                this.scrollOffset = MathHelper.func_76125_a((int)(this.mousePos(mouseX, mouseY) - this.zeroThumbPos() - this.thumbSize / 2), (int)0, (int)this.maxScrollSize());
            }
            this.prevScrollOffset = this.scrollOffset;
            this.mousePos = this.mousePos(mouseX, mouseY);
            if (!this.scrollThumbRect.contains(mouseX, mouseY)) {
                this.updateScroll();
            }
        }
    }

    @Override
    public void mouseUp(int mouseX, int mouseY, int button) {
        if (button == 0 && this.mouseDown) {
            this.mouseDown = false;
        }
    }

    private int zeroThumbPos() {
        return this.direction == Direction.HORIZONTAL ? this.getX() : this.getY();
    }

    private int mousePos(int mouseX, int mouseY) {
        return this.direction == Direction.HORIZONTAL ? mouseX : mouseY;
    }

    public void setScroll(int value) {
        this.currentValue = MathHelper.func_76125_a((int)value, (int)0, (int)this.maxValue);
        this.scrollChanged();
    }

    @Override
    public void keyTyped(char c, int key) {
        if (this.canChangeScroll()) {
            if (key == 207) {
                this.setScroll(Integer.MAX_VALUE);
            } else if (key == 199) {
                this.setScroll(0);
            } else if (key == 201) {
                this.setScroll(this.getValue() - this.getHeight() - 1);
            } else if (key == 209) {
                this.setScroll(this.getValue() + this.getHeight() + 1);
            }
        }
    }

    @Override
    public void onUpdate() {
        int wheel = GuiBase.dWheel;
        if (wheel != 0 && this.canChangeScroll() && this.maxValue > 0) {
            this.currentValue = MathHelper.func_76125_a((int)(this.currentValue - wheel * this.wheelScrollStep), (int)0, (int)this.maxValue);
            this.scrollChanged();
        }
    }

    private boolean canChangeScroll() {
        return this.wheelScrollEverywhere || this.wheelScrollParent && this.parent.isMouseOverControl(this.mouseX, this.mouseY) || this.isMouseOverControl(this.mouseX, this.mouseY);
    }

    private void scrollChanged() {
        this.scrollOffset = (int)((float)this.maxScrollSize() / (float)this.maxValue * (float)this.currentValue);
        this.updateThumbRect();
        if (this.listener != null) {
            this.listener.onValueChanged(this);
        }
    }

    public void updateScroll() {
        this.updateThumbRect();
        float widthPerScroll = (float)this.maxScrollSize() / (float)(this.maxValue + 1);
        this.currentValue = (int)((float)this.scrollOffset / widthPerScroll);
        this.currentValue = MathHelper.func_76125_a((int)this.currentValue, (int)0, (int)this.maxValue);
        if (this.listener != null) {
            this.listener.onValueChanged(this);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float renderTick) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        if (this.mouseDown) {
            this.scrollOffset = MathHelper.func_76125_a((int)(this.prevScrollOffset + this.mousePos(mouseX, mouseY) - this.mousePos), (int)0, (int)this.maxScrollSize());
            this.updateScroll();
        }
        GuiHelper.drawOutlinedRect(this.getBounds(), -11842741, -4802890);
        this.drawThumb(mouseX, mouseY);
    }

    private void drawThumb(int mouseX, int mouseY) {
        if (this.maxValue > 0) {
            if (this.scrollThumbRect.contains(mouseX, mouseY) || this.mouseDown) {
                GuiHelper.drawOutlinedRect(this.scrollThumbRect, -1, -11842741);
            } else {
                GuiHelper.drawRect(this.scrollThumbRect, -11842741);
            }
        }
    }

    public static enum Direction {
        VERTICAL,
        HORIZONTAL;

    }
}

