/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control;

import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ControlContainer;
import cubex2.cs3.ingame.gui.control.IValueListener;
import cubex2.cs3.ingame.gui.control.Slider;
import cubex2.cs3.ingame.gui.control.builder.ControlBuilder;

public class ScrollContainer
extends ControlContainer
implements IValueListener<Slider> {
    private static final int WHEEL_STEP = 13;
    public static final int SLIDER_WIDTH = 12;
    private int totalHeight;
    private Slider slider;
    ControlContainer scrollerWindow;
    private ControlContainer contentContainer;
    private int currentScroll;

    public ScrollContainer(int totalHeight, int width, int height, Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(width, height, anchor, offsetX, offsetY, parent);
        this.totalHeight = totalHeight;
        this.slider = (Slider)this.verticalSlider(totalHeight).top(0).bottom(0).right(0).width(12).add();
        this.slider.setValueListener(this);
        this.slider.setWheelScrollEverywhere(true);
        this.slider.setWheelScrollStep(13);
        this.scrollerWindow = (ControlContainer)this.container().at(0, 0).bottom(this.slider, 0, true).right(this.slider, 3).add();
        this.scrollerWindow.enableScissor = true;
        this.contentContainer = (ControlContainer)new ContentContainerBuilder(this, this.scrollerWindow).fill().add();
    }

    public ControlContainer content() {
        return this.contentContainer;
    }

    public void disableGlobalScrolling() {
        this.slider.setWheelScrollEverywhere(false);
        this.slider.setWheelScrollParent(true);
    }

    private void setScroll(int value) {
        if (this.currentScroll != value) {
            this.currentScroll = value;
            this.contentContainer.offsetY = -this.currentScroll;
            this.onParentResized();
        }
    }

    public void automaticTotalHeight() {
        int newHeight = 0;
        for (Control c : this.content().controls) {
            if (c.getY() + c.getHeight() <= newHeight) continue;
            newHeight = c.getY() + c.getHeight();
        }
        this.totalHeight = newHeight - this.getY();
        this.onParentResized();
    }

    @Override
    public void onParentResized() {
        super.onParentResized();
        this.slider.setMaxValue(this.totalHeight - this.slider.getHeight());
    }

    @Override
    public void onValueChanged(Slider control) {
        this.setScroll(this.slider.getValue());
    }

    private static final class ContentContainerBuilder
    extends ControlBuilder<ContentContainer> {
        private final ScrollContainer scroller;

        public ContentContainerBuilder(ScrollContainer scroller, ControlContainer c) {
            super(c);
            this.scroller = scroller;
        }

        @Override
        protected ContentContainer newInstance() {
            return new ContentContainer(this.scroller, this.width, this.height, this.anchor, this.offsetX, this.offsetY, this.container);
        }
    }

    private static final class ContentContainer
    extends ControlContainer {
        private final ScrollContainer scroller;

        public ContentContainer(ScrollContainer scroller, int width, int height, Anchor anchor, int offsetX, int offsetY, Control parent) {
            super(width, height, anchor, offsetX, offsetY, parent);
            this.scroller = scroller;
        }

        @Override
        public boolean isMouseOverControl(int mouseX, int mouseY) {
            return this.scroller.scrollerWindow.isMouseOverControl(mouseX, mouseY);
        }
    }
}

