/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameData;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.IRecipeInputToolTipModifier;
import cubex2.cs3.lib.Textures;
import cubex2.cs3.util.GuiHelper;
import cubex2.cs3.util.RecipeInput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class RecipeInputDisplay
extends Control {
    private RecipeInput recipeInput;
    private ItemStack currentRenderStack;
    private List<ItemStack> renderStacks;
    private boolean drawSlotBackground = false;
    private boolean clearOnRightClick = false;
    private boolean showItemData = true;
    private int tickCounter = 1;
    private int currentIndex = 0;
    private IRecipeInputToolTipModifier toolTipModifier;

    public RecipeInputDisplay(Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(16, 16, anchor, offsetX, offsetY, parent);
        if (this.rootControl instanceof IRecipeInputToolTipModifier) {
            this.toolTipModifier = (IRecipeInputToolTipModifier)((Object)this.rootControl);
        }
    }

    public RecipeInputDisplay setDrawSlotBackground() {
        this.drawSlotBackground = true;
        return this;
    }

    public void setClearOnRightClick() {
        this.clearOnRightClick = true;
    }

    public RecipeInput getRecipeInput() {
        return this.recipeInput;
    }

    public void setRecipeInput(RecipeInput recipeInput) {
        if (recipeInput == null) {
            this.recipeInput = null;
            this.currentRenderStack = null;
            this.renderStacks = null;
            return;
        }
        if (recipeInput instanceof IRecipeInputToolTipModifier) {
            this.toolTipModifier = (IRecipeInputToolTipModifier)((Object)recipeInput);
        }
        this.recipeInput = recipeInput;
        this.renderStacks = Lists.newArrayList();
        for (ItemStack stack : recipeInput.getStacks()) {
            if (stack.func_77973_b() == null) continue;
            if (stack.func_77981_g() && stack.func_77960_j() == Short.MAX_VALUE) {
                ArrayList subItems = Lists.newArrayList();
                stack.func_77973_b().func_150895_a(stack.func_77973_b(), null, (List)subItems);
                this.renderStacks.addAll(subItems);
                continue;
            }
            if (stack.func_77984_f() && stack.func_77960_j() == Short.MAX_VALUE) {
                for (int i = 0; i < 5; ++i) {
                    this.renderStacks.add(new ItemStack(stack.func_77973_b(), 1, (int)((double)stack.func_77958_k() * 0.25 * (double)i)));
                }
                continue;
            }
            this.renderStacks.add(stack);
        }
        if (this.renderStacks.size() == 0) {
            this.renderStacks = null;
        } else {
            this.currentRenderStack = this.renderStacks.get(0);
        }
        if (this.currentRenderStack != null && this.currentRenderStack.func_77960_j() == Short.MAX_VALUE) {
            this.currentRenderStack.func_77964_b(0);
        }
    }

    @Override
    public void mouseDown(int mouseX, int mouseY, int button) {
        if (button == 1 && this.clearOnRightClick) {
            this.setRecipeInput(null);
        }
    }

    @Override
    public void onUpdate() {
        if (this.renderStacks != null && this.tickCounter++ % 20 == 0) {
            this.currentIndex = (this.currentIndex + 1) % this.renderStacks.size();
            this.currentRenderStack = this.renderStacks.get(this.currentIndex);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float renderTick) {
        if (this.drawSlotBackground) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.field_71446_o.func_110577_a(Textures.CONTROLS);
            this.drawTexturedModalRect(this.bounds.getX() - 1, this.bounds.getY() - 1, 200, 0, 18, 18);
        }
        if (this.currentRenderStack == null) {
            return;
        }
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        GuiBase.itemRenderer.field_77023_b = 100.0f;
        GuiBase.itemRenderer.func_82406_b(this.mc.field_71466_p, this.mc.field_71446_o, this.currentRenderStack, this.bounds.getX(), this.bounds.getY());
        GuiBase.itemRenderer.func_77021_b(this.mc.field_71466_p, this.mc.field_71446_o, this.currentRenderStack, this.bounds.getX(), this.bounds.getY());
        GuiBase.itemRenderer.field_77023_b = 0.0f;
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        RenderHelper.func_74518_a();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (this.currentRenderStack == null) {
            return;
        }
        if (this.isMouseOverControl(mouseX, mouseY)) {
            FontRenderer font;
            List list = this.currentRenderStack.func_82840_a((EntityPlayer)this.mc.field_71439_g, this.mc.field_71474_y.field_82882_x);
            for (int k = 0; k < list.size(); ++k) {
                if (k == 0) {
                    list.set(k, this.currentRenderStack.func_77953_t().field_77937_e.toString() + list.get(k));
                    continue;
                }
                list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
            }
            if (this.showItemData) {
                if (this.recipeInput.isOreClass()) {
                    list.add(EnumChatFormatting.GRAY + "Ore class: " + this.recipeInput.getInput());
                } else {
                    ItemStack stack = (ItemStack)this.recipeInput.getInput();
                    list.add(EnumChatFormatting.GRAY + "Name: " + GameData.itemRegistry.func_148750_c((Object)stack.func_77973_b()));
                    list.add(EnumChatFormatting.GRAY + "DV: " + stack.func_77960_j());
                }
            }
            if (this.toolTipModifier != null) {
                this.toolTipModifier.modifyToolTip(list, this.recipeInput);
            }
            GuiHelper.drawHoveringText(list, mouseX, mouseY, (font = this.currentRenderStack.func_77973_b().getFontRenderer(this.currentRenderStack)) == null ? this.mc.field_71466_p : font);
        }
    }
}

