/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control;

import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.ButtonUpDown;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ControlContainer;
import cubex2.cs3.ingame.gui.control.TextBox;
import net.minecraft.util.MathHelper;

public class NumericUpDown
extends ControlContainer {
    private TextBox tb;
    private ButtonUpDown btnUp;
    private ButtonUpDown btnDown;
    private int minValue = 0;
    private int maxValue = Integer.MAX_VALUE;

    public NumericUpDown(int width, Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(width, 20, anchor, offsetX, offsetY, parent);
        this.tb = (TextBox)this.textBox().height(-1).left(0).top(0).bottom(0).right(0).add();
        this.tb.setNumbersOnly(true);
        this.btnUp = (ButtonUpDown)this.buttonUp().top(1).right(1).add();
        this.btnDown = (ButtonUpDown)this.buttonDown().bottom(1).right(1).add();
        this.updateControls();
    }

    public void setMinValue(int value) {
        this.minValue = value;
        this.updateControls();
    }

    public void setMaxValue(int value) {
        this.maxValue = value;
        this.updateControls();
    }

    public void setValue(int value) {
        value = MathHelper.func_76125_a((int)value, (int)this.minValue, (int)this.maxValue);
        this.tb.setText(value + "");
        this.btnUp.setEnabled(value < this.maxValue);
        this.btnDown.setEnabled(value > this.minValue);
    }

    public int getValue() {
        this.updateControls();
        return Integer.parseInt(this.tb.getText());
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button, boolean intoControl) {
        super.mouseClicked(mouseX, mouseY, button, intoControl);
        if (!this.tb.hasFocus()) {
            this.updateControls();
        }
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnUp) {
            this.setValue(this.getValue() + (GuiBase.func_146272_n() ? 5 : 1));
        } else if (c == this.btnDown) {
            this.setValue(this.getValue() - (GuiBase.func_146272_n() ? 5 : 1));
        }
    }

    private void updateControls() {
        try {
            if (this.tb.getText().length() == 0 || Integer.parseInt(this.tb.getText()) < this.minValue) {
                this.tb.setText(this.minValue + "");
            } else if (Integer.parseInt(this.tb.getText()) > this.maxValue) {
                this.tb.setText(this.maxValue + "");
            }
        }
        catch (NumberFormatException e) {
            this.tb.setText(this.maxValue + "");
        }
        int value = Integer.parseInt(this.tb.getText());
        this.btnUp.setEnabled(value < this.maxValue);
        this.btnDown.setEnabled(value > this.minValue);
    }
}

