/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control;

import com.google.common.collect.Lists;
import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ControlContainer;
import cubex2.cs3.ingame.gui.control.IValueListener;
import cubex2.cs3.ingame.gui.control.ItemDisplay;
import cubex2.cs3.ingame.gui.control.Slider;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.util.Filter;
import cubex2.cs3.util.GuiHelper;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.ArrayUtils;

public class ItemSelectionArray
extends ControlContainer
implements IValueListener<Slider> {
    private Slider slider;
    private final ItemDisplay[] displays;
    private TextBox tbSearch;
    private final ArrayList<ItemStack> stacks;
    private final ArrayList<ItemStack> allStacks;
    private int selectedIndex = -1;
    private int currentScroll = 0;
    private int maxScroll;
    private final int rows = 7;
    private final int columns = 7;
    private final int size = 23;
    public Filter<ItemStack> filter;
    public IValueListener<ItemSelectionArray> listener;

    public ItemSelectionArray(ArrayList<ItemStack> stacks, int width, int height, Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(width, height, anchor, offsetX, offsetY, parent);
        this.allStacks = stacks;
        this.stacks = Lists.newArrayList(stacks);
        this.displays = new ItemDisplay[49];
        this.updateMaxScroll();
        this.tbSearch = (TextBox)this.textBox().fillWidth(0).bottom(0).add();
        this.slider = (Slider)this.verticalSlider(this.calculateTotalHeight()).top(0).height(156).right(0).width(20).add();
        this.slider.setValueListener(this);
        this.slider.setWheelScrollEverywhere(true);
        this.slider.setWheelScrollStep(23);
        for (int row = 0; row < 7; ++row) {
            for (int col = 0; col < 7; ++col) {
                this.displays[col + row * 7] = ((ItemDisplay)this.itemDisplay().left(col * 23).top(row * 23 + 1).add()).setDrawSlotBackground();
            }
        }
        this.updateItems();
    }

    private int calculateTotalHeight() {
        if (this.maxScroll <= 6) {
            return 0;
        }
        int numRows = this.stacks.size() / 7 + (this.stacks.size() % 7 != 0 ? 1 : 0);
        if (numRows > 7) {
            numRows -= 6;
        }
        return numRows * 22 + (numRows - 1) * 1;
    }

    private void updateItems() {
        for (int row = 0; row < 7; ++row) {
            for (int col = 0; col < 7; ++col) {
                int index = col + (row + this.currentScroll) * 7;
                ItemStack stack = index >= this.stacks.size() ? null : this.stacks.get(index);
                this.displays[col + row * 7].setItemStack(stack);
                this.displays[col + row * 7].setEnabled(stack != null);
                this.displays[col + row * 7].setVisible(stack != null);
            }
        }
    }

    public ItemStack getSelectedStack() {
        return this.selectedIndex < 0 ? null : this.stacks.get(this.selectedIndex);
    }

    public TextBox getSearchBox() {
        return this.tbSearch;
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        int index;
        if (c instanceof ItemDisplay && (index = ArrayUtils.indexOf((Object[])this.displays, (Object)c)) != -1) {
            this.selectedIndex = index + this.currentScroll * 7;
            if (this.listener != null) {
                this.listener.onValueChanged(this);
            }
        }
    }

    @Override
    public void keyTyped(char c, int key) {
        String prev = this.tbSearch.getText();
        super.keyTyped(c, key);
        String now = this.tbSearch.getText();
        if (!prev.equals(now)) {
            this.filterChanged(this.tbSearch.getText());
        }
    }

    private void filterChanged(String filterText) {
        this.stacks.clear();
        for (ItemStack stack : this.allStacks) {
            if (!this.filter.matches(stack, filterText)) continue;
            this.stacks.add(stack);
        }
        this.selectedIndex = -1;
        if (this.listener != null) {
            this.listener.onValueChanged(this);
        }
        this.updateMaxScroll();
        this.currentScroll = 0;
        this.slider.setMaxValue(this.calculateTotalHeight());
        this.updateItems();
    }

    private void updateMaxScroll() {
        this.maxScroll = this.stacks.size() / 7;
        if (this.stacks.size() % 7 != 0) {
            ++this.maxScroll;
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float renderTick) {
        int displayIndex;
        super.draw(mouseX, mouseY, renderTick);
        if (this.selectedIndex != -1 && (displayIndex = this.selectedIndex - this.currentScroll * 7) >= 0 && displayIndex < this.displays.length) {
            ItemDisplay display = this.displays[displayIndex];
            GuiHelper.drawBorder(display.getX() - 2, display.getY() - 2, display.getX() + display.getWidth() + 2, display.getY() + display.getHeight() + 2, -65536);
        }
    }

    @Override
    public void onValueChanged(Slider control) {
        this.currentScroll = MathHelper.func_76125_a((int)(control.getValue() / 23), (int)0, (int)this.maxScroll);
        this.updateItems();
    }
}

