/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameData;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.ISelectElementCallback;
import cubex2.cs3.ingame.gui.WindowSelectBlock;
import cubex2.cs3.ingame.gui.WindowSelectItem;
import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.IToolTipModifier;
import cubex2.cs3.ingame.gui.control.ValidityControl;
import cubex2.cs3.lib.Textures;
import cubex2.cs3.util.GuiHelper;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class ItemDisplay
extends ValidityControl<ItemDisplay>
implements ISelectElementCallback<ItemStack> {
    private ItemStack originStack;
    private ItemStack currentRenderStack;
    private List<ItemStack> renderStacks;
    private boolean drawSlotBackground = false;
    private boolean showIdAndDamageValue = false;
    private boolean clearOnRightClick = false;
    private int tickCounter = 1;
    private int currentIndex = 0;
    private boolean usesSelectItemDialog = false;
    private boolean usesSelectBlockDialog = false;
    private boolean dialogWildCards = false;
    private Predicate<ItemStack> filter;
    private IToolTipModifier toolTipModifier;

    public ItemDisplay(Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(16, 16, anchor, offsetX, offsetY, parent);
    }

    public ItemDisplay useSelectItemDialog(boolean wildCardStacks) {
        this.usesSelectItemDialog = true;
        this.dialogWildCards = wildCardStacks;
        return this;
    }

    public ItemDisplay useSelectBlockDialog() {
        this.usesSelectBlockDialog = true;
        return this;
    }

    public ItemDisplay useSelectBlockDialog(Predicate<ItemStack> filter) {
        this.usesSelectBlockDialog = true;
        this.filter = filter;
        return this;
    }

    public ItemDisplay setDrawSlotBackground() {
        this.drawSlotBackground = true;
        return this;
    }

    public void setToolTipModifier(IToolTipModifier modifier) {
        this.toolTipModifier = modifier;
    }

    public void setShowIdAndDV() {
        this.showIdAndDamageValue = true;
    }

    public void setClearOnRightClick() {
        this.clearOnRightClick = true;
    }

    public void setStackSize(int stackSize) {
        if (this.originStack != null) {
            this.originStack.field_77994_a = stackSize;
            if (this.renderStacks != null) {
                for (ItemStack renderStack : this.renderStacks) {
                    renderStack.field_77994_a = this.originStack.field_77994_a;
                }
            } else {
                this.currentRenderStack.field_77994_a = this.originStack.field_77994_a;
            }
        }
        this.valueChanged();
    }

    public ItemStack getItemStack() {
        return this.originStack;
    }

    public void setItemStack(ItemStack stack) {
        if (stack == null) {
            this.originStack = null;
            this.currentRenderStack = null;
            this.renderStacks = null;
            this.valueChanged();
            return;
        }
        this.originStack = stack;
        this.currentRenderStack = stack;
        if (stack.func_77973_b() != null) {
            if (stack.func_77981_g() && stack.func_77960_j() == Short.MAX_VALUE) {
                this.renderStacks = Lists.newArrayList();
                stack.func_77973_b().func_150895_a(stack.func_77973_b(), null, this.renderStacks);
                if (this.renderStacks.size() == 0) {
                    this.renderStacks = null;
                } else {
                    for (ItemStack renderStack : this.renderStacks) {
                        renderStack.field_77994_a = this.originStack.field_77994_a;
                    }
                    this.currentRenderStack = this.renderStacks.get(0);
                }
            } else if (stack.func_77984_f() && stack.func_77960_j() == Short.MAX_VALUE) {
                this.renderStacks = Lists.newArrayList();
                for (int i = 0; i < 5; ++i) {
                    this.renderStacks.add(new ItemStack(stack.func_77973_b(), 1, (int)((double)stack.func_77958_k() * 0.25 * (double)i)));
                }
                this.currentRenderStack = this.renderStacks.get(0);
            } else {
                this.renderStacks = null;
            }
            if (this.currentRenderStack.func_77960_j() == Short.MAX_VALUE) {
                this.currentRenderStack.func_77964_b(0);
            }
        }
        this.valueChanged();
    }

    @Override
    public void mouseDown(int mouseX, int mouseY, int button) {
        if (button == 1 && this.clearOnRightClick) {
            this.setItemStack(null);
        } else if (button == 0) {
            if (this.usesSelectItemDialog) {
                GuiBase.openWindow(new WindowSelectItem(this.dialogWildCards, this));
            } else if (this.usesSelectBlockDialog) {
                GuiBase.openWindow(new WindowSelectBlock(false, false, this, this.filter));
            }
        }
    }

    @Override
    public void onUpdate() {
        if (this.renderStacks != null && this.tickCounter++ % 20 == 0) {
            this.currentIndex = (this.currentIndex + 1) % this.renderStacks.size();
            this.currentRenderStack = this.renderStacks.get(this.currentIndex);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float renderTick) {
        if (this.drawSlotBackground) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.field_71446_o.func_110577_a(Textures.CONTROLS);
            this.drawTexturedModalRect(this.bounds.getX() - 1, this.bounds.getY() - 1, 200, 0, 18, 18);
        }
        if (this.currentRenderStack == null || this.currentRenderStack.func_77973_b() == null) {
            return;
        }
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        GuiBase.itemRenderer.field_77023_b = 100.0f;
        GuiBase.itemRenderer.func_82406_b(this.mc.field_71466_p, this.mc.field_71446_o, this.currentRenderStack, this.bounds.getX(), this.bounds.getY());
        GuiBase.itemRenderer.func_77021_b(this.mc.field_71466_p, this.mc.field_71446_o, this.currentRenderStack, this.bounds.getX(), this.bounds.getY());
        GuiBase.itemRenderer.field_77023_b = 0.0f;
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        RenderHelper.func_74518_a();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (this.currentRenderStack == null || this.currentRenderStack.func_77973_b() == null) {
            return;
        }
        if (this.isMouseOverControl(mouseX, mouseY)) {
            FontRenderer font;
            List list = this.currentRenderStack.func_82840_a((EntityPlayer)this.mc.field_71439_g, this.mc.field_71474_y.field_82882_x);
            for (int k = 0; k < list.size(); ++k) {
                if (k == 0) {
                    list.set(k, this.currentRenderStack.func_77953_t().field_77937_e.toString() + list.get(k));
                    continue;
                }
                list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
            }
            if (this.showIdAndDamageValue) {
                list.add(EnumChatFormatting.GRAY + "Name: " + GameData.itemRegistry.func_148750_c((Object)this.originStack.func_77973_b()));
                list.add(EnumChatFormatting.GRAY + "DV: " + this.originStack.func_77960_j());
            }
            if (this.toolTipModifier != null) {
                this.toolTipModifier.modifyToolTip(list, this.originStack);
            }
            GuiHelper.drawHoveringText(list, mouseX, mouseY, (font = this.currentRenderStack.func_77973_b().getFontRenderer(this.currentRenderStack)) == null ? this.mc.field_71466_p : font);
        }
    }

    @Override
    public void itemSelected(ItemStack stack) {
        this.setItemStack(stack);
    }
}

