/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.ISelectElementCallback;
import cubex2.cs3.ingame.gui.WindowSelectBlock;
import cubex2.cs3.ingame.gui.WindowSelectItem;
import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ControlContainer;
import cubex2.cs3.ingame.gui.control.IValueListener;
import cubex2.cs3.ingame.gui.control.ItemDisplay;
import cubex2.cs3.ingame.gui.control.Slider;
import cubex2.cs3.util.ItemStackHelper;
import java.util.List;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;

public class HorizontalItemList
extends ControlContainer
implements IValueListener<Slider>,
ISelectElementCallback<ItemStack> {
    private ItemDisplay[] displays;
    private Slider slider;
    private int numItems;
    private List<ItemStack> stacks = Lists.newArrayList();
    public boolean canRemove = false;
    public boolean canAdd = false;
    public boolean blocksOnly = false;
    public boolean itemWildcards = false;
    public IValueListener<HorizontalItemList> listener;
    private final Predicate<ItemStack> IS_NOT_IN_LIST = new Predicate<ItemStack>(){

        public boolean apply(ItemStack input) {
            for (ItemStack stack : HorizontalItemList.this.stacks) {
                if (!ItemStackHelper.itemStackEqual(stack, input)) continue;
                return false;
            }
            return true;
        }
    };

    public HorizontalItemList(int numItems, Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(18 * numItems, 28, anchor, offsetX, offsetY, parent);
        this.numItems = numItems;
        this.displays = new ItemDisplay[numItems];
        for (int i = 0; i < numItems; ++i) {
            this.displays[i] = (ItemDisplay)this.itemDisplay().left(i * 18 + 1).top(0).add();
            this.displays[i].setDrawSlotBackground();
        }
        this.slider = (Slider)this.horizontalSlider(0).fillWidth(0).bottom(0).height(8).add();
        this.slider.setValueListener(this);
        this.slider.setWheelScrollParent(true);
        this.onValueChanged(this.slider);
    }

    public List<ItemStack> getStacks() {
        return this.stacks;
    }

    public void setItems(List<ItemStack> stacks) {
        this.stacks.clear();
        this.stacks.addAll(stacks);
        if (this.canAdd && stacks.size() >= this.numItems) {
            this.stacks.add(null);
        }
        this.slider.setMaxValue(Math.max(stacks.size() - this.numItems, 0) * 18);
        this.slider.updateScroll();
    }

    public void addItem(ItemStack stack) {
        if (this.stacks.size() > 1 && this.stacks.get(this.stacks.size() - 1) == null) {
            this.stacks.remove(this.stacks.size() - 1);
        }
        this.stacks.add(stack);
        if (this.canAdd && this.stacks.size() >= this.numItems) {
            this.stacks.add(null);
        }
        this.slider.setMaxValue(Math.max(this.stacks.size() - this.numItems, 0) * 18);
        this.slider.updateScroll();
        if (this.listener != null) {
            this.listener.onValueChanged(this);
        }
    }

    private void removeItem(ItemStack stack) {
        this.stacks.remove(stack);
        if (this.stacks.size() > 1 && this.stacks.get(this.stacks.size() - 1) == null && this.stacks.size() <= this.numItems) {
            this.stacks.remove(this.stacks.size() - 1);
        }
        this.slider.setMaxValue(Math.max(this.stacks.size() - this.numItems, 0) * 18);
        this.slider.updateScroll();
        if (this.listener != null) {
            this.listener.onValueChanged(this);
        }
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY, int button) {
        int index = ArrayUtils.indexOf((Object[])this.displays, (Object)c);
        if (index != -1) {
            if (button == 1 && this.canRemove && this.displays[index].getItemStack() != null) {
                this.removeItem(this.displays[index].getItemStack());
            } else if (button == 0 && this.canAdd && this.displays[index].getItemStack() == null) {
                if (this.blocksOnly) {
                    GuiBase.openWindow(new WindowSelectBlock(false, false, this, this.IS_NOT_IN_LIST));
                } else {
                    GuiBase.openWindow(new WindowSelectItem(this.itemWildcards, this));
                }
            }
        }
    }

    @Override
    public void onValueChanged(Slider slider) {
        for (int i = 0; i < this.displays.length; ++i) {
            int stackIndex = Math.round((float)slider.getValue() / 18.0f) + i;
            if (stackIndex >= this.stacks.size()) {
                this.displays[i].setItemStack(null);
                continue;
            }
            this.displays[i].setItemStack(this.stacks.get(stackIndex));
        }
    }

    @Override
    public void itemSelected(ItemStack element) {
        this.addItem(element);
    }
}

