/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control;

import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.IStringProvider;
import cubex2.cs3.util.GuiHelper;
import net.minecraft.util.MathHelper;
import org.lwjgl.util.Rectangle;

public class DropBox<T>
extends Control {
    private final T[] values;
    private T selectedValue = null;
    private boolean isExpanded = false;
    private int offset = 0;
    private int maxShowedValues = 6;
    private IStringProvider<T> stringProvider;
    public boolean drawNullValue = false;

    public DropBox(T[] values, int width, int height, Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(width, height, anchor, offsetX, offsetY, parent);
        this.values = values;
    }

    public void setStringProvider(IStringProvider<T> provider) {
        this.stringProvider = provider;
    }

    public void setSelectedValue(T value) {
        this.selectedValue = value;
    }

    public T getSelectedValue() {
        return this.selectedValue;
    }

    @Override
    public void onUpdate() {
        int wheel = GuiBase.dWheel;
        if (wheel != 0 && this.isExpanded && this.values.length > this.maxShowedValues) {
            this.offset = MathHelper.func_76125_a((int)(this.offset - wheel), (int)0, (int)(this.values.length - this.maxShowedValues));
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float renderTick) {
        int borderColor = this.getBounds().contains(mouseX, mouseY) && !this.isExpanded ? -1 : -11842741;
        GuiHelper.drawOutlinedRect(this.getBounds(), borderColor, -4802890);
        if (this.drawNullValue || this.selectedValue != null) {
            this.mc.field_71466_p.func_78276_b(this.getTextToDraw(this.selectedValue), this.bounds.getX() + 3, this.bounds.getY() + 3, -16777216);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (this.isExpanded) {
            for (int i = 0; i < Math.min(this.values.length, this.maxShowedValues); ++i) {
                int ry;
                int index = i + this.offset;
                int rx = this.getX() + 10;
                Rectangle rect = new Rectangle(rx, ry = this.getY() + (i + 1) * this.getHeight(), this.getWidth(), this.getHeight());
                int borderColor = rect.contains(mouseX, mouseY) ? -1 : -11842741;
                GuiHelper.drawOutlinedRect(rect, borderColor, -4802890);
                this.mc.field_71466_p.func_78276_b(this.getTextToDraw(this.values[index]), rx + 3, ry + 3, -16777216);
            }
        }
    }

    private String getTextToDraw(T value) {
        return this.stringProvider == null ? value.toString() : this.stringProvider.getStringFor(value);
    }

    @Override
    public void mouseDown(int mouseX, int mouseY, int button) {
        if (button == 0) {
            boolean bl = this.isExpanded = !this.isExpanded;
            if (this.isExpanded) {
                GuiBase.lockInput(this);
            } else {
                GuiBase.releaseInput();
            }
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button, boolean intoControl) {
        if (this.isExpanded && !intoControl) {
            int index;
            Rectangle expandedRect = new Rectangle(this.getX() + 10, this.getY() + this.getHeight(), this.getWidth(), this.getHeight() * this.values.length);
            if (expandedRect.contains(mouseX, mouseY) && (index = (mouseY - expandedRect.getY()) / this.getHeight() + this.offset) < this.values.length) {
                this.selectedValue = this.values[index];
            }
            this.isExpanded = false;
            GuiBase.releaseInput();
        }
    }

    @Override
    public boolean isMouseOverControl(int mouseX, int mouseY) {
        return super.isMouseOverControl(mouseX, mouseY);
    }
}

