/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control;

import com.google.common.collect.Lists;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.IValidityControl;
import cubex2.cs3.ingame.gui.control.Label;
import cubex2.cs3.ingame.gui.control.Slider;
import cubex2.cs3.ingame.gui.control.builder.BlockDisplayBuilder;
import cubex2.cs3.ingame.gui.control.builder.ButtonBuilder;
import cubex2.cs3.ingame.gui.control.builder.ButtonDocBuilder;
import cubex2.cs3.ingame.gui.control.builder.ButtonUpDownBuilder;
import cubex2.cs3.ingame.gui.control.builder.CheckBoxBuilder;
import cubex2.cs3.ingame.gui.control.builder.ContainerBuilder;
import cubex2.cs3.ingame.gui.control.builder.ControlBuilder;
import cubex2.cs3.ingame.gui.control.builder.CookProgressBarBuilder;
import cubex2.cs3.ingame.gui.control.builder.DropBoxBuilder;
import cubex2.cs3.ingame.gui.control.builder.FuelProgressBarBuilder;
import cubex2.cs3.ingame.gui.control.builder.HorizontalItemListBuilder;
import cubex2.cs3.ingame.gui.control.builder.IconTextBoxBuilder;
import cubex2.cs3.ingame.gui.control.builder.ImageProgressBarBuilder;
import cubex2.cs3.ingame.gui.control.builder.InfoButtonBuilder;
import cubex2.cs3.ingame.gui.control.builder.InventorySlotBuilder;
import cubex2.cs3.ingame.gui.control.builder.ItemDisplayBuilder;
import cubex2.cs3.ingame.gui.control.builder.LabelBuilder;
import cubex2.cs3.ingame.gui.control.builder.ListBoxBuilder;
import cubex2.cs3.ingame.gui.control.builder.NumericUpDownBuilder;
import cubex2.cs3.ingame.gui.control.builder.PictureBoxBuilder;
import cubex2.cs3.ingame.gui.control.builder.PlayerDisplayBuilder;
import cubex2.cs3.ingame.gui.control.builder.PlayerInventoryAreaBuilder;
import cubex2.cs3.ingame.gui.control.builder.RecipeInputDisplayBuilder;
import cubex2.cs3.ingame.gui.control.builder.ScrollContainerBuilder;
import cubex2.cs3.ingame.gui.control.builder.SliderBuilder;
import cubex2.cs3.ingame.gui.control.builder.TabControlBuilder;
import cubex2.cs3.ingame.gui.control.builder.TextBoxBuilder;
import cubex2.cs3.ingame.gui.control.builder.TextFieldBuilder;
import cubex2.cs3.ingame.gui.control.builder.TextureTextBoxBuilder;
import cubex2.cs3.ingame.gui.control.builder.WorldDisplayBuilder;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;
import cubex2.cs3.tileentity.TileEntityInventory;
import cubex2.cs3.util.RecipeInput;
import cubex2.cs3.util.ScissorHelper;
import cubex2.cs3.util.SimulatedWorld;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ControlContainer
extends Control {
    public ControlContainer defaultBuilderContainer = this;
    public boolean defaultNoOffset = false;
    public boolean enableScissor = false;
    protected List<Control> controls = Lists.newArrayList();
    public Control lastControl;
    private Control lastRow;
    private Control lastCol;

    public ControlContainer(int width, int height, Anchor anchor, int offsetX, int offsetY, Control parent) {
        super(width, height, anchor, offsetX, offsetY, parent);
    }

    public void addControl(Control c) {
        if (this.rootControl instanceof Window && c instanceof IValidityControl) {
            this.rootControl.addValidityControl((IValidityControl)((Object)c));
        }
        if (c.tabStop) {
            this.rootControl.tabStopControls.add(c);
        }
        this.controls.add(c);
        this.lastControl = c;
    }

    public List<Control> getControls() {
        return this.controls;
    }

    public Control getControlAt(int x, int y) {
        for (int i = this.controls.size() - 1; i >= 0; --i) {
            Control c = this.controls.get(i);
            if (!c.isMouseOverControl(x, y)) continue;
            if (c instanceof ControlContainer) {
                ControlContainer cc = (ControlContainer)c;
                Control c1 = cc.getControlAt(x, y);
                return c1 != null ? c1 : cc;
            }
            return c;
        }
        if (this.isMouseOverControl(x, y)) {
            return this;
        }
        return null;
    }

    @Override
    public void onParentResized() {
        super.onParentResized();
        for (Control control : this.controls) {
            control.onParentResized();
        }
    }

    @Override
    public void onUpdate() {
        int first = this.firstControl();
        int num = this.numControls();
        for (int i = first; i < first + num && i < this.controls.size(); ++i) {
            Control c = this.controls.get(i);
            c.onUpdate();
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button, boolean intoControl) {
        boolean wasLocked = GuiBase.inputLockedControl != null;
        int first = this.firstControl();
        int num = this.numControls();
        for (int i = first; i < first + num && i < this.controls.size(); ++i) {
            boolean isLocked;
            Control c = this.controls.get(i);
            if (!c.isEnabled() || !c.isVisible() || !c.canHandleInput()) continue;
            boolean clickedControl = c.isMouseOverControl(mouseX, mouseY);
            c.mouseClicked(mouseX, mouseY, button, clickedControl);
            if (clickedControl) {
                c.mouseDown(mouseX, mouseY, button);
                this.controlClicked(c, mouseX, mouseY, button);
                if (button == 0) {
                    this.controlClicked(c, mouseX, mouseY);
                }
            }
            boolean bl = isLocked = GuiBase.inputLockedControl != null;
            if (wasLocked && !isLocked) break;
        }
    }

    @Override
    public boolean canHandleInput() {
        if (GuiBase.inputLockedControl == null) {
            return true;
        }
        for (Control control : this.controls) {
            if (control == GuiBase.inputLockedControl) {
                return true;
            }
            if (!(control instanceof ControlContainer) || !control.canHandleInput()) continue;
            return true;
        }
        return false;
    }

    protected void controlClicked(Control c, int mouseX, int mouseY, int button) {
    }

    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (this.parent instanceof ControlContainer) {
            ((ControlContainer)this.parent).controlClicked(c, mouseX, mouseY);
        }
    }

    @Override
    public void mouseUp(int mouseX, int mouseY, int button) {
        boolean wasLocked = GuiBase.inputLockedControl != null;
        int first = this.firstControl();
        int num = this.numControls();
        for (int i = first; i < first + num && i < this.controls.size(); ++i) {
            boolean isLocked;
            Control c = this.controls.get(i);
            if (!c.isEnabled() || !c.isVisible() || !c.canHandleInput()) continue;
            c.mouseUp(mouseX, mouseY, button);
            boolean bl = isLocked = GuiBase.inputLockedControl != null;
            if (wasLocked && !isLocked) break;
        }
    }

    @Override
    public void keyTyped(char c, int key) {
        int first = this.firstControl();
        int num = this.numControls();
        for (int i = first; i < first + num && i < this.controls.size(); ++i) {
            Control c_ = this.controls.get(i);
            if (!c_.isEnabled() || !c_.isVisible() || !c_.canHandleInput()) continue;
            c_.keyTyped(c, key);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float renderTick) {
        if (this.enableScissor) {
            ScissorHelper.startScissor(this.mc, this.bounds);
        }
        int first = this.firstControl();
        int num = this.numControls();
        for (int i = first; i < first + num && i < this.controls.size(); ++i) {
            Control c = this.controls.get(i);
            if (!c.isVisible()) continue;
            c.draw(mouseX, mouseY, renderTick);
        }
        if (this.enableScissor) {
            ScissorHelper.endScissor();
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        int first = this.firstControl();
        int num = this.numControls();
        for (int i = first; i < first + num && i < this.controls.size(); ++i) {
            Control c = this.controls.get(i);
            if (!c.isVisible()) continue;
            c.drawForeground(mouseX, mouseY);
        }
    }

    protected int firstControl() {
        return 0;
    }

    protected int numControls() {
        return this.controls.size();
    }

    public Label row(String text, String infoText) {
        Label label = this.row(text);
        this.infoButton(infoText).rightTo(label).add();
        return label;
    }

    public Label row(String text) {
        return this.row(this.label(text));
    }

    public Label row(String text, int offset) {
        return this.row(this.label(text), offset, this.defaultNoOffset);
    }

    public Label row(String text, String infoText, int offset) {
        Label label = this.row(this.label(text), offset, this.defaultNoOffset);
        this.infoButton(infoText).rightTo(label).add();
        return label;
    }

    public <T extends Control> T row(ControlBuilder<T> builder) {
        return this.row(builder, 4, this.defaultNoOffset);
    }

    public <T extends Control> T row(ControlBuilder<T> builder, boolean noOffset) {
        return this.row(builder, 4, noOffset);
    }

    public <T extends Control> T row(ControlBuilder<T> builder, int offset, boolean noOffset) {
        if (this.defaultBuilderContainer != this) {
            return this.defaultBuilderContainer.row(builder, offset, noOffset);
        }
        if (builder.width == 0 && !(builder instanceof LabelBuilder) && !(builder instanceof CheckBoxBuilder)) {
            builder.right(7);
        }
        this.lastRow = this.lastRow == null ? builder.top(noOffset ? 0 : 7).left(noOffset ? 0 : 7).add() : builder.top(this.lastRow, offset).left(noOffset ? 0 : 7).add();
        return (T)this.lastRow;
    }

    public <T extends Control> T col(ControlBuilder<T> builder) {
        return this.col(builder, 3);
    }

    public <T extends Control> T col(ControlBuilder<T> builder, int offset) {
        this.lastCol = this.lastCol == null ? builder.left(0).fillHeight(0).add() : builder.left(this.lastCol, offset).fillHeight(0).add();
        return (T)this.lastCol;
    }

    public LabelBuilder label(String text) {
        return new LabelBuilder(text, this.defaultBuilderContainer);
    }

    public TextBoxBuilder textBox() {
        return new TextBoxBuilder(this.defaultBuilderContainer);
    }

    public <T> DropBoxBuilder<T> dropBox(T[] values) {
        return new DropBoxBuilder<T>(values, this.defaultBuilderContainer);
    }

    public ButtonBuilder button(String text) {
        return new ButtonBuilder(text, this.defaultBuilderContainer);
    }

    public ItemDisplayBuilder itemDisplay() {
        return new ItemDisplayBuilder(null, this.defaultBuilderContainer);
    }

    public ItemDisplayBuilder itemDisplay(ItemStack stack) {
        return new ItemDisplayBuilder(stack, this.defaultBuilderContainer);
    }

    public InfoButtonBuilder infoButton(String text) {
        return new InfoButtonBuilder(text, this.defaultBuilderContainer);
    }

    public ButtonUpDownBuilder buttonUpDown(boolean up) {
        return new ButtonUpDownBuilder(up, this.defaultBuilderContainer);
    }

    public ButtonUpDownBuilder buttonUp() {
        return this.buttonUpDown(true);
    }

    public ButtonUpDownBuilder buttonDown() {
        return this.buttonUpDown(false);
    }

    public PlayerDisplayBuilder playerDisplay() {
        return new PlayerDisplayBuilder(this.defaultBuilderContainer);
    }

    public CheckBoxBuilder checkBox() {
        return new CheckBoxBuilder(this.defaultBuilderContainer);
    }

    public CheckBoxBuilder checkBox(boolean checked) {
        return new CheckBoxBuilder(this.defaultBuilderContainer).checked(checked);
    }

    public CheckBoxBuilder checkBox(String text) {
        return new CheckBoxBuilder(text, this.defaultBuilderContainer);
    }

    public CheckBoxBuilder checkBox(String text, boolean checked) {
        return new CheckBoxBuilder(text, this.defaultBuilderContainer).checked(checked);
    }

    public TextFieldBuilder textField() {
        return new TextFieldBuilder(this.defaultBuilderContainer);
    }

    public PictureBoxBuilder pictureBox(ResourceLocation texture, int u, int v) {
        return new PictureBoxBuilder(texture, u, v, this.defaultBuilderContainer);
    }

    public WorldDisplayBuilder worldDisplay(SimulatedWorld world) {
        return new WorldDisplayBuilder(world, this.defaultBuilderContainer);
    }

    public RecipeInputDisplayBuilder recipeInputDisplay() {
        return new RecipeInputDisplayBuilder(null, this.defaultBuilderContainer);
    }

    public RecipeInputDisplayBuilder recipeInputDisplay(RecipeInput input) {
        return new RecipeInputDisplayBuilder(input, this.defaultBuilderContainer);
    }

    public TabControlBuilder tabControl(int tabWidth, int tabHeight) {
        return new TabControlBuilder(tabWidth, tabHeight, this.defaultBuilderContainer);
    }

    public SliderBuilder verticalSlider(int maxValue) {
        return new SliderBuilder(Slider.Direction.VERTICAL, maxValue, this.defaultBuilderContainer);
    }

    public SliderBuilder horizontalSlider(int maxValue) {
        return new SliderBuilder(Slider.Direction.HORIZONTAL, maxValue, this.defaultBuilderContainer);
    }

    public <T> ListBoxBuilder<T> listBox(ListBoxDescription<T> desc) {
        return new ListBoxBuilder<T>(desc, this.defaultBuilderContainer);
    }

    public ContainerBuilder container() {
        return new ContainerBuilder(this.defaultBuilderContainer);
    }

    public BlockDisplayBuilder blockDisplay(Block block) {
        return this.blockDisplay(block, 0);
    }

    public BlockDisplayBuilder blockDisplay(Block block, int meta) {
        return new BlockDisplayBuilder(block, meta, this.defaultBuilderContainer);
    }

    public NumericUpDownBuilder numericUpDown() {
        return new NumericUpDownBuilder(this.defaultBuilderContainer);
    }

    public HorizontalItemListBuilder horItemList(int numItems) {
        return new HorizontalItemListBuilder(numItems, this.defaultBuilderContainer);
    }

    public ScrollContainerBuilder scrollContainer(int totalHeight) {
        return new ScrollContainerBuilder(totalHeight, this.defaultBuilderContainer);
    }

    public ButtonDocBuilder buttonDoc(String text, String path) {
        return new ButtonDocBuilder(text, path, this.defaultBuilderContainer);
    }

    public IconTextBoxBuilder iconTextBox(BaseContentPack pack, String subFolder) {
        return new IconTextBoxBuilder(pack, subFolder, this.defaultBuilderContainer);
    }

    public TextureTextBoxBuilder textureTextBox(BaseContentPack pack, String subFolder) {
        return new TextureTextBoxBuilder(pack, subFolder, this.defaultBuilderContainer);
    }

    public PlayerInventoryAreaBuilder playerInventoryArea() {
        return new PlayerInventoryAreaBuilder(this.defaultBuilderContainer);
    }

    public InventorySlotBuilder inventorySlot() {
        return new InventorySlotBuilder(this.defaultBuilderContainer);
    }

    public ImageProgressBarBuilder imageProgressBar(ResourceLocation texture, int u, int v, int direction) {
        return new ImageProgressBarBuilder(texture, u, v, direction, this);
    }

    public CookProgressBarBuilder cookProgressBar(String name, TileEntityInventory tile, ResourceLocation texture, int u, int v, int direction) {
        return new CookProgressBarBuilder(name, tile, texture, u, v, direction, this);
    }

    public FuelProgressBarBuilder fuelProgressBar(String name, TileEntityInventory tile, ResourceLocation texture, int u, int v, int direction) {
        return new FuelProgressBarBuilder(name, tile, texture, u, v, direction, this);
    }
}

