/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.control;

import cpw.mods.fml.client.FMLClientHandler;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Anchor;
import cubex2.cs3.ingame.gui.control.Dock;
import cubex2.cs3.ingame.gui.control.Padding;
import cubex2.cs3.ingame.gui.control.ToolTipProvider;
import cubex2.cs3.util.GuiHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.util.Rectangle;

public abstract class Control {
    public static final Control ROOT_CONTROL_DUMMY = new Control(0, 0, null){

        @Override
        protected boolean isRootDummy() {
            return true;
        }

        @Override
        public void onParentResized() {
            this.bounds = GuiBase.INSTANCE.getBounds();
        }

        @Override
        protected void setBounds() {
            this.bounds = GuiBase.INSTANCE.getBounds();
        }

        @Override
        public boolean isMouseOverControl(int mouseX, int mouseY) {
            return true;
        }
    };
    public Anchor anchor;
    public Dock dock = Dock.NONE;
    public Padding padding = new Padding();
    public int offsetX = 0;
    public int offsetY = 0;
    public final Minecraft mc;
    protected Window rootControl;
    protected Control parent;
    public boolean parentMouseOverCheck = true;
    protected Rectangle bounds;
    public int width;
    public int height;
    protected float zLevel = 0.0f;
    private boolean isEnabled = true;
    private boolean isVisible = true;
    public ToolTipProvider toolTipProvider;
    public Object controlTag;
    public boolean tabStop = false;

    public Control(int width, int height, Control parent) {
        this(width, height, null, parent);
    }

    public Control(int width, int height, Anchor anchor, Control parent) {
        this(width, height, anchor, 0, 0, parent);
    }

    public Control(int width, int height, Anchor anchor, int offsetX, int offsetY, Control parent) {
        this.parent = parent;
        this.width = width;
        this.height = height;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.mc = FMLClientHandler.instance().getClient();
        if (this instanceof Window) {
            this.rootControl = (Window)this;
            if (this.parent == null) {
                this.parent = ROOT_CONTROL_DUMMY;
            }
            this.dock = Dock.CENTER;
        } else if (parent != null) {
            this.rootControl = parent.rootControl;
        } else if (!this.isRootDummy()) {
            throw new IllegalStateException("Control has no root control.");
        }
        if (anchor == null) {
            anchor = new Anchor(0, -1, 0, -1);
            anchor.controlLeft = parent;
            anchor.sameSideLeft = true;
            anchor.controlTop = parent;
            anchor.sameSideTop = true;
            anchor.controlRight = parent;
            anchor.controlBottom = parent;
        }
        this.anchor = anchor;
        this.setBounds();
    }

    public boolean isMouseOverControl(int mouseX, int mouseY) {
        return (!this.parentMouseOverCheck || this.parent.isMouseOverControl(mouseX, mouseY)) && this.bounds.contains(mouseX, mouseY);
    }

    protected void setBounds() {
        if (this.parent == ROOT_CONTROL_DUMMY) {
            this.parent.setBounds();
        }
        Rectangle parentRect = this.parent.bounds;
        Padding padding = this.parent.padding;
        if (this.dock == Dock.TOP) {
            this.bounds = new Rectangle(parentRect.getX() + padding.left, parentRect.getY() + padding.top, parentRect.getWidth() - padding.left - padding.right, this.height);
        } else if (this.dock == Dock.BOTTOM) {
            this.bounds = new Rectangle(parentRect.getX() + padding.left, parentRect.getY() + parentRect.getHeight() - padding.bottom - this.height, parentRect.getWidth() - padding.left - padding.right, this.height);
        } else if (this.dock == Dock.LEFT) {
            this.bounds = new Rectangle(parentRect.getX() + padding.left, parentRect.getY() + padding.top, this.width, parentRect.getHeight() - padding.top - padding.bottom);
        } else if (this.dock == Dock.RIGHT) {
            this.bounds = new Rectangle(parentRect.getX() + parentRect.getWidth() - padding.right - this.width, parentRect.getY() + padding.top, this.width, parentRect.getHeight() - padding.top - padding.bottom);
        } else if (this.dock == Dock.FILL) {
            this.bounds = new Rectangle(parentRect.getX() + padding.left, parentRect.getY() + padding.top, parentRect.getWidth() - padding.left - padding.right, parentRect.getHeight() - padding.top - padding.bottom);
        } else if (this.dock == Dock.CENTER) {
            this.bounds = new Rectangle(parentRect.getX() + (parentRect.getWidth() - this.width) / 2, parentRect.getY() + (parentRect.getHeight() - this.height) / 2, this.width, this.height);
        } else {
            int posX = 0;
            int posY = 0;
            int width = this.width;
            int height = this.height;
            if (this.anchor.isLeft() && this.anchor.isRight()) {
                if (width > 0) {
                    posX = this.anchor.getAnchorLeft() + (this.anchor.getAnchorRight() - this.anchor.getAnchorLeft() - width) / 2;
                } else {
                    posX = this.anchor.getAnchorLeft() + this.anchor.distanceLeft;
                    width = this.anchor.getAnchorRight() - this.anchor.distanceRight - posX;
                }
            } else if (this.anchor.isLeft()) {
                posX = this.anchor.getAnchorLeft() + this.anchor.distanceLeft;
            } else if (this.anchor.isRight()) {
                posX = this.anchor.getAnchorRight() - this.anchor.distanceRight - width;
            }
            if (this.anchor.isTop() && this.anchor.isBottom()) {
                if (height > 0) {
                    posY = this.anchor.getAnchorTop() + (this.anchor.getAnchorBottom() - this.anchor.getAnchorTop() - height) / 2;
                } else {
                    posY = this.anchor.getAnchorTop() + this.anchor.distanceTop;
                    height = this.anchor.getAnchorBottom() - this.anchor.distanceBottom - posY;
                }
            } else if (this.anchor.isTop()) {
                posY = this.anchor.getAnchorTop() + this.anchor.distanceTop;
            } else if (this.anchor.isBottom()) {
                posY = this.anchor.getAnchorBottom() - this.anchor.distanceBottom - height;
            }
            this.bounds = new Rectangle(posX, posY, width, height);
        }
        this.bounds.setX(this.bounds.getX() + this.offsetX);
        this.bounds.setY(this.bounds.getY() + this.offsetY);
    }

    public boolean hasFocus() {
        return this.rootControl.getFocusedControl() == this;
    }

    public boolean canReleaseFocus() {
        return true;
    }

    public void onFocus() {
    }

    public void onUnfocus() {
    }

    public void onParentResized() {
        this.setBounds();
    }

    public boolean canHandleInput() {
        return GuiBase.inputLockedControl == null || GuiBase.inputLockedControl == this;
    }

    public Control getParent() {
        return this.parent;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getX() {
        return this.bounds.getX();
    }

    public int getY() {
        return this.bounds.getY();
    }

    public int getWidth() {
        return this.bounds.getWidth();
    }

    public int getHeight() {
        return this.bounds.getHeight();
    }

    public void setEnabled(boolean value) {
        this.isEnabled = value;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setVisible(boolean value) {
        this.isVisible = value;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void onUpdate() {
    }

    public void mouseClicked(int mouseX, int mouseY, int button, boolean intoControl) {
    }

    public void mouseDown(int mouseX, int mouseY, int button) {
    }

    public void mouseUp(int mouseX, int mouseY, int button) {
    }

    public void keyTyped(char c, int key) {
    }

    public void draw(int mouseX, int mouseY, float renderTick) {
    }

    public void drawForeground(int mouseX, int mouseY) {
        String toolTip;
        if (this.toolTipProvider != null && this.isMouseOverControl(mouseX, mouseY) && (toolTip = this.toolTipProvider.getToolTip(this)) != null && toolTip.length() > 0) {
            GuiHelper.drawToolTip(toolTip.split("\n"), mouseX, mouseY, this.mc.field_71466_p);
        }
    }

    public void drawTexturedModalRect(Rectangle rect, int u, int v) {
        this.drawTexturedModalRect(rect.getX(), rect.getY(), u, v, rect.getWidth(), rect.getHeight());
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)this.zLevel, (double)((float)(u + 0) * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.zLevel, (double)((float)(u + width) * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)this.zLevel, (double)((float)(u + width) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.zLevel, (double)((float)(u + 0) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78381_a();
    }

    public void drawString(String text, int x, int y, int color) {
        this.mc.field_71466_p.func_78261_a(text, x, y, color);
    }

    public void drawCenteredString(String text, int x, int y, int color) {
        this.mc.field_71466_p.func_78261_a(text, x - this.mc.field_71466_p.func_78256_a(text) / 2, y, color);
    }

    protected boolean isRootDummy() {
        return false;
    }
}

