/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.common;

import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.ISelectElementCallback;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.listbox.IListBoxItemClickListener;
import cubex2.cs3.ingame.gui.control.listbox.ListBox;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;
import cubex2.cs3.util.Filter;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class WindowSelectTexture
extends Window
implements IListBoxItemClickListener<ResourceLocation> {
    private final ISelectElementCallback<String> callback;
    private ListBox<ResourceLocation> listBox;
    private String selectedTexture;

    public WindowSelectTexture(List<ResourceLocation> textures, ISelectElementCallback<String> callback) {
        super("Select Texture", 66, 171, 211);
        this.callback = callback;
        ListBoxDescription desc = new ListBoxDescription(7, 7);
        desc.elementWidth = 134;
        desc.elementHeight = 70;
        desc.columns = 1;
        desc.rows = 2;
        desc.elements = textures;
        desc.hasSearchBar = true;
        desc.filter = Filter.RESOURCE_LOCATION;
        this.listBox = (ListBox)this.listBox(desc).left(7).top(7).right(7).add();
        this.claimFocus(this.listBox.getSearchBox());
        this.btnSelect.setEnabled(false);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCancel) {
            this.selectedTexture = null;
            GuiBase.openPrevWindow();
        } else if (c == this.btnSelect) {
            if (this.callback != null) {
                this.callback.itemSelected(this.selectedTexture);
            }
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    public void itemClicked(ResourceLocation item, ListBox<ResourceLocation> listBox, int button) {
        this.btnSelect.setEnabled(listBox.getSelectedIndex() != -1);
        this.selectedTexture = listBox.getSelectedItem().toString();
    }
}

