/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.common;

import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.ISelectElementCallback;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.Tab;
import cubex2.cs3.ingame.gui.control.TabChangedListener;
import cubex2.cs3.ingame.gui.control.TabControl;
import cubex2.cs3.ingame.gui.control.listbox.IListBoxItemClickListener;
import cubex2.cs3.ingame.gui.control.listbox.ListBox;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;
import cubex2.cs3.util.ClientHelper;
import cubex2.cs3.util.Filter;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class WindowSelectIcon
extends Window
implements IListBoxItemClickListener<ResourceLocation>,
TabChangedListener {
    private ListBox<ResourceLocation> lbPack;
    private ListBox<ResourceLocation> lbAll;
    private TabControl tabControl;
    private String selectedTexture;
    private ISelectElementCallback<String> callback;

    public WindowSelectIcon(List<ResourceLocation> packIcons, List<ResourceLocation> allIcons, ISelectElementCallback<String> callback) {
        super("Select Texture", 66, 197, 211);
        this.callback = callback;
        this.tabControl = (TabControl)this.tabControl(70, 20).fill().add();
        this.tabControl.listener = this;
        Tab packTab = this.tabControl.addTab("Pack");
        Tab allTab = this.tabControl.addTab("All");
        ListBoxDescription desc = new ListBoxDescription(7, 7);
        desc.elementWidth = 22;
        desc.elementHeight = 22;
        desc.columns = 7;
        desc.rows = 7;
        desc.elements = packIcons;
        desc.hasSearchBar = true;
        desc.filter = Filter.RESOURCE_LOCATION;
        desc.listBoxItemMeta = 1;
        this.lbPack = (ListBox)packTab.listBox(desc).left(7).top(7).right(7).add();
        this.claimFocus(this.lbPack.getSearchBox());
        ListBoxDescription desc1 = new ListBoxDescription(7, 7);
        desc1.elementWidth = 22;
        desc1.elementHeight = 22;
        desc1.columns = 7;
        desc1.rows = 7;
        desc1.elements = allIcons;
        desc1.hasSearchBar = true;
        desc1.filter = Filter.RESOURCE_LOCATION;
        desc1.listBoxItemMeta = 1;
        this.lbAll = (ListBox)allTab.listBox(desc1).left(7).top(7).right(7).add();
        this.btnSelect.setEnabled(false);
    }

    public String getSelectedTexture() {
        return this.selectedTexture;
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCancel) {
            this.selectedTexture = null;
            GuiBase.openPrevWindow();
        } else if (c == this.btnSelect) {
            if (this.callback != null) {
                this.callback.itemSelected(this.selectedTexture);
            }
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    public void itemClicked(ResourceLocation item, ListBox<ResourceLocation> listBox, int button) {
        ListBox<ResourceLocation> otherLB = listBox == this.lbPack ? this.lbAll : this.lbPack;
        this.btnSelect.setEnabled(listBox.getSelectedIndex() != -1);
        otherLB.removeSelection();
        this.selectedTexture = ClientHelper.resourceToIconString(listBox.getSelectedItem());
    }

    @Override
    public void tabChanged(TabControl tabControl, Tab tab) {
        if (tab.title.equals("Pack")) {
            this.claimFocus(this.lbPack.getSearchBox());
        } else {
            this.claimFocus(this.lbAll.getSearchBox());
        }
    }
}

