/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.common;

import cubex2.cs3.common.attribute.AttributeContainer;
import cubex2.cs3.common.attribute.AttributeData;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.NumericUpDown;

public class WindowEditInteger
extends Window {
    protected AttributeContainer container;
    private String fieldName;
    private NumericUpDown nup;
    private int minValue = 0;
    private int maxValue = Integer.MAX_VALUE;

    public WindowEditInteger(AttributeData attributeData, AttributeContainer container) {
        super(attributeData.getDisplayName(), 34, 150, 55);
        this.container = container;
        this.fieldName = attributeData.field.getName();
        String info = attributeData.attribute.additionalInfo();
        if (info.length() > 0) {
            this.minValue = Integer.parseInt(info.split("-")[0]);
            this.maxValue = Integer.parseInt(info.split("-")[1]);
        }
        this.initControls(attributeData.desc);
    }

    public WindowEditInteger(String fieldName, String desc, int min, int max, AttributeContainer container) {
        super(fieldName, 34, 150, 55);
        this.container = container;
        this.fieldName = fieldName;
        this.minValue = min;
        this.maxValue = max;
        this.initControls(desc);
    }

    private void initControls(String desc) {
        if (desc != null) {
            this.infoButton(desc).right(7).top(13).add();
            this.nup = (NumericUpDown)this.numericUpDown().top(7).left(7).right(this.lastControl, 3).add();
        } else {
            this.nup = (NumericUpDown)this.numericUpDown().top(7).fillWidth(7).add();
        }
        this.nup.setMinValue(this.minValue);
        this.nup.setMaxValue(this.maxValue);
        this.nup.setValue((Integer)this.container.getAttribute(this.fieldName));
    }

    @Override
    protected void handleEditButtonClicked() {
        this.container.setAttribute(this.fieldName, this.nup.getValue());
        this.applyChangedValue();
        this.container.getPack().save();
        GuiBase.openPrevWindow();
    }

    protected void applyChangedValue() {
    }
}

