/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.common;

import cubex2.cs3.common.attribute.AttributeContainer;
import cubex2.cs3.common.attribute.AttributeData;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.lib.TextBoxValidators;

public class WindowEditFloat
extends Window {
    protected AttributeContainer container;
    private String fieldName;
    private TextBox textBox;

    public WindowEditFloat(AttributeData attributeData, AttributeContainer container) {
        super(attributeData.getDisplayName(), 34, 150, 55);
        this.container = container;
        this.fieldName = attributeData.field.getName();
        this.initControls(attributeData.desc);
    }

    public WindowEditFloat(String fieldName, String desc, AttributeContainer container) {
        super(fieldName, 34, 150, 55);
        this.container = container;
        this.fieldName = fieldName;
        this.initControls(desc);
    }

    private void initControls(String desc) {
        if (desc != null) {
            this.infoButton(desc).right(7).top(13).add();
            this.textBox = (TextBox)this.textBox().top(7).left(7).right(this.lastControl, 3).height(20).add();
        } else {
            this.textBox = (TextBox)this.textBox().top(7).fillWidth(7).height(20).add();
        }
        this.textBox.setValidityProvider(TextBoxValidators.FLOAT);
        this.textBox.setText(String.valueOf((char[])this.container.getAttribute(this.fieldName)));
    }

    @Override
    protected void handleEditButtonClicked() {
        this.container.setAttribute(this.fieldName, Float.valueOf(Float.parseFloat(this.textBox.getText())));
        this.applyChangedValue();
        this.container.getPack().save();
        GuiBase.openPrevWindow();
    }

    protected void applyChangedValue() {
    }
}

