/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.common;

import com.google.common.collect.Lists;
import cubex2.cs3.common.AttributeContent;
import cubex2.cs3.common.attribute.AttributeData;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.common.WindowEditBoolean;
import cubex2.cs3.ingame.gui.common.WindowEditFloat;
import cubex2.cs3.ingame.gui.common.WindowEditInteger;
import cubex2.cs3.ingame.gui.common.WindowEditScript;
import cubex2.cs3.ingame.gui.control.listbox.IListBoxItemClickListener;
import cubex2.cs3.ingame.gui.control.listbox.ListBox;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;

public class WindowEditAttributeContent
extends Window
implements IListBoxItemClickListener<AttributeData> {
    protected final AttributeContent content;
    private ListBox<AttributeData> listBox;

    public WindowEditAttributeContent(AttributeContent content) {
        super(content.getName(), 1, 263, 160);
        this.content = content;
        ListBoxDescription desc = new ListBoxDescription(7, 7);
        desc.rows = 9;
        desc.columns = 1;
        desc.elements = Lists.newArrayList((Object[])content.getContainer().getAttributeDatas(content.getTypeString()));
        desc.canSelect = false;
        desc.sorted = true;
        this.listBox = (ListBox)this.listBox(desc).fillWidth(7).top(7).add();
    }

    @Override
    public void itemClicked(AttributeData item, ListBox<AttributeData> listBox, int button) {
        try {
            Class<? extends Window> windowClass = this.content.getContainer().getWindowClass(item);
            if (windowClass == WindowEditScript.class) {
                GuiBase.openWindow(new WindowEditScript(item.field.getName(), this.content.getContainer()));
            } else if (windowClass == WindowEditInteger.class) {
                GuiBase.openWindow(new WindowEditInteger(item, this.content.getContainer()));
            } else if (windowClass == WindowEditFloat.class) {
                GuiBase.openWindow(new WindowEditFloat(item, this.content.getContainer()));
            } else if (windowClass == WindowEditBoolean.class) {
                GuiBase.openWindow(new WindowEditBoolean(item, this.content.getContainer()));
            } else {
                GuiBase.openWindow(windowClass.getConstructor(this.content.getClass()).newInstance(this.content));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

