/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.block;

import cubex2.cs3.block.attributes.FacingAttributes;
import cubex2.cs3.common.WrappedBlock;
import cubex2.cs3.ingame.gui.block.WindowEditTexturesBase;
import cubex2.cs3.ingame.gui.control.Button;
import cubex2.cs3.ingame.gui.control.CheckBox;
import cubex2.cs3.ingame.gui.control.Control;

public class WindowEditTexturesFacing
extends WindowEditTexturesBase {
    private static final String[] textures = new String[]{"front", "top", "back", "bottom", "sides"};
    private Button btnRotate;
    private int rotation = 3;
    private CheckBox cbRotateSideTextures;
    private FacingAttributes attributes;
    private boolean prevRotateSideTextures;

    public WindowEditTexturesFacing(WrappedBlock block, boolean transparent, boolean semiTransparent, boolean tileTransparent) {
        super(block, textures, transparent, semiTransparent, tileTransparent);
        this.world.setMetadata(3, 0, 0, 0);
        this.attributes = (FacingAttributes)block.container;
        this.cbRotateSideTextures = (CheckBox)this.checkBox("Rotate side textures").below(this.lastCheckBox, 7).add();
        this.cbRotateSideTextures.setIsChecked(this.attributes.rotateSideTextures);
        this.btnRotate = (Button)this.button("Rotate").width(40).bottom(this.worldDisplay, 0, true).right(this.worldDisplay, 3).add();
        this.worldDisplay.setCam(1.5f, 1.5f, 1.5f);
        this.worldDisplay.setLook(0.5f, 0.5f, 0.5f);
    }

    public WindowEditTexturesFacing(WrappedBlock block) {
        this(block, true, true, true);
    }

    @Override
    protected void applyChanges() {
        this.attributes.rotateSideTextures = this.cbRotateSideTextures.getIsChecked();
        super.applyChanges();
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnRotate) {
            this.rotation = (this.rotation + 1) % 6;
            this.world.setMetadata(this.rotation, 0, 0, 0);
        } else {
            super.controlClicked(c, mouseX, mouseY);
        }
    }

    @Override
    protected void preDraw() {
        this.prevRotateSideTextures = this.attributes.rotateSideTextures;
        this.attributes.rotateSideTextures = this.cbRotateSideTextures.getIsChecked();
    }

    @Override
    protected void postDraw() {
        this.attributes.rotateSideTextures = this.prevRotateSideTextures;
    }
}

