/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.block;

import cubex2.cs3.block.attributes.BlockAttributes;
import cubex2.cs3.common.WrappedBlock;
import cubex2.cs3.ingame.gui.block.WindowEditBlockAttribute;
import cubex2.cs3.ingame.gui.control.CheckBox;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.IconTextBox;
import cubex2.cs3.ingame.gui.control.Label;
import cubex2.cs3.ingame.gui.control.WorldDisplay;
import cubex2.cs3.ingame.gui.control.builder.LabelBuilder;
import cubex2.cs3.util.ClientHelper;
import cubex2.cs3.util.SimulatedWorld;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.init.Blocks;
import org.lwjgl.opengl.GL11;

public abstract class WindowEditTexturesBase
extends WindowEditBlockAttribute {
    protected static final String[] DEFAULT_TEXTURES = new String[]{"bottom", "top", "north", "south", "east", "west"};
    private String[] textures;
    private Label[] labels;
    private IconTextBox[] textBoxes;
    private CheckBox cbTransparent;
    private CheckBox cbSemiTransparent;
    private CheckBox cbRotatable;
    private CheckBox cbTileTransparent;
    protected CheckBox lastCheckBox;
    protected WorldDisplay worldDisplay;
    protected SimulatedWorld world;

    public WindowEditTexturesBase(WrappedBlock block, String[] textures) {
        this(block, textures, false, true, false, true);
    }

    public WindowEditTexturesBase(WrappedBlock block, String[] textures, boolean transparent, boolean semiTransparent, boolean tileTransparent) {
        this(block, textures, transparent, semiTransparent, tileTransparent, false);
    }

    public WindowEditTexturesBase(WrappedBlock block, String[] textures, boolean transparent, boolean semiTransparent, boolean tileTransparent, boolean singleCol) {
        super(block, "textures", (singleCol ? 0 : 150) + 153, 200);
        int i;
        this.textures = textures;
        this.world = new SimulatedWorld(-1, -1, -2, 2, 0, 1);
        this.world.setBlock(this.wrappedBlock.block, 0, 0, 0);
        for (i = -1; i < 3; ++i) {
            for (int j = -2; j < 2; ++j) {
                this.world.setBlock(Blocks.field_150348_b, i, -1, j);
            }
        }
        this.labels = new Label[textures.length];
        this.textBoxes = new IconTextBox[textures.length];
        for (i = 0; i < this.labels.length; ++i) {
            LabelBuilder lb = this.label(textures[i]);
            lb = i == 0 ? (LabelBuilder)lb.at(7, 7) : (!singleCol && i == 1 ? (LabelBuilder)lb.at(160, 7) : (LabelBuilder)lb.below(this.textBoxes[i - (singleCol ? 1 : 2)]));
            this.labels[i] = (Label)lb.add();
            this.textBoxes[i] = (IconTextBox)this.iconTextBox(block.getPack(), "blocks").below(this.labels[i]).height(13).width(118).add();
            this.textBoxes[i].setMaxLength(256);
            String textureString = ((BlockAttributes)this.container).getTexture(textures[i]).getTextForGui(this.wrappedBlock.getPack());
            this.textBoxes[i].setText(textureString);
        }
        Control below = singleCol ? this.textBoxes[this.textBoxes.length - 1] : this.textBoxes[4];
        int belowDist = 9;
        Control below2 = singleCol ? this.textBoxes[this.textBoxes.length - 1] : this.textBoxes[4];
        int belowDist2 = 20;
        if (transparent) {
            this.cbTransparent = (CheckBox)this.checkBox("Transparent").below(below, belowDist).add();
            this.cbTransparent.setIsChecked(((BlockAttributes)this.container).transparent);
            below = this.cbTransparent;
            belowDist = 7;
            this.lastCheckBox = this.cbTransparent;
        }
        if (semiTransparent) {
            this.cbSemiTransparent = (CheckBox)this.checkBox("Semi Transparent").below(below, belowDist).add();
            this.cbRotatable = (CheckBox)this.checkBox("Rotatable").below(below2, belowDist2).add();
            this.cbSemiTransparent.setIsChecked(((BlockAttributes)this.container).semiTransparent);
            this.cbRotatable.setIsChecked(true);
            below = this.cbSemiTransparent;
            belowDist = 7;
            below2 = this.cbRotatable;
            belowDist2 = 9;
            this.lastCheckBox = this.cbSemiTransparent;
        }
        if (tileTransparent) {
            this.cbTileTransparent = (CheckBox)this.checkBox("Tile Transparent").below(below, belowDist).add();
            this.cbTileTransparent.setIsChecked(((BlockAttributes)this.container).tileTransparent);
            this.lastCheckBox = this.cbTileTransparent;
        }
        this.worldDisplay = singleCol ? (WorldDisplay)this.worldDisplay(this.world).fillWidth(7).bottom(this.btnCancel, 3).height(89).add() : (WorldDisplay)this.worldDisplay(this.world).right(7).bottom(this.btnCancel, 3).size(75, 75).add();
        this.worldDisplay.rotate = false;
        if (singleCol) {
            this.worldDisplay.setCam(-0.25f, 1.5f, 0.5f);
            this.worldDisplay.setLook(0.5f, 0.5f, 0.5f);
        } else {
            this.worldDisplay.camY = 2.0f;
            this.worldDisplay.camX = 0.5f;
            this.worldDisplay.lookX = 1.0f;
        }
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (this.cbTileTransparent != null && this.cbTransparent != null && this.cbTileTransparent.getIsChecked() && !this.cbTransparent.getIsChecked()) {
            this.cbTransparent.setIsChecked(true);
        }
        this.handleDefaultButtonClick(c);
    }

    @Override
    protected void applyChanges() {
        for (int i = 0; i < this.textBoxes.length; ++i) {
            String textureName;
            String text = this.textBoxes[i].getText().trim();
            String modId = text.contains(":") ? text.split(":")[0] : this.wrappedBlock.getPack().id.toLowerCase();
            String string = textureName = text.contains(":") && text.indexOf(58) != text.length() - 1 ? text.split(":")[1] : text;
            if (textureName.length() <= 0) continue;
            ((BlockAttributes)this.container).getTexture((String)this.textures[i]).iconString = modId + ":" + textureName;
        }
        if (this.cbTransparent != null) {
            ((BlockAttributes)this.container).transparent = this.cbTransparent.getIsChecked();
        }
        if (this.cbSemiTransparent != null) {
            ((BlockAttributes)this.container).semiTransparent = this.cbSemiTransparent.getIsChecked();
        }
        if (this.cbTileTransparent != null) {
            ((BlockAttributes)this.container).tileTransparent = this.cbTileTransparent.getIsChecked();
        }
        ClientHelper.refreshResources(this.mc);
    }

    @Override
    public void draw(int mouseX, int mouseY, float renderTick) {
        boolean prevTile = ((BlockAttributes)this.container).tileTransparent;
        boolean prevTrans = ((BlockAttributes)this.container).transparent;
        boolean prevSemi = ((BlockAttributes)this.container).semiTransparent;
        if (this.cbTileTransparent != null) {
            ((BlockAttributes)this.container).tileTransparent = this.cbTileTransparent.getIsChecked();
        }
        if (this.cbTransparent != null) {
            ((BlockAttributes)this.container).transparent = this.cbTransparent.getIsChecked();
        }
        if (this.cbSemiTransparent != null) {
            ((BlockAttributes)this.container).semiTransparent = this.cbSemiTransparent.getIsChecked();
        }
        this.preDraw();
        super.draw(mouseX, mouseY, renderTick);
        this.postDraw();
        ((BlockAttributes)this.container).tileTransparent = prevTile;
        ((BlockAttributes)this.container).transparent = prevTrans;
        ((BlockAttributes)this.container).semiTransparent = prevSemi;
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)3008);
        for (int i = 0; i < this.textBoxes.length; ++i) {
            if (this.textBoxes[i] == null || this.textBoxes[i].getText() == null || this.textBoxes[i].getText().length() == 0) continue;
            int posX = this.textBoxes[i].getX() + this.textBoxes[i].getWidth() + 3;
            int posY = this.textBoxes[i].getY() - 1;
            if (this.textBoxes[i].getLocation() == null) continue;
            this.mc.field_71446_o.func_110577_a(this.textBoxes[i].getLocation());
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)0.0625f, (float)0.0625f, (float)1.0f);
            this.drawTexturedModalRect(posX * 16, posY * 16, 0, 0, 256, 256);
            GL11.glScalef((float)16.0f, (float)16.0f, (float)1.0f);
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
    }

    protected void preDraw() {
    }

    protected void postDraw() {
    }
}

