/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.block;

import com.google.common.collect.Lists;
import cubex2.cs3.block.attributes.PressurePlateAttributes;
import cubex2.cs3.common.WrappedBlock;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.ISelectElementCallback;
import cubex2.cs3.ingame.gui.WindowSelectString;
import cubex2.cs3.ingame.gui.block.WindowEditBlockAttribute;
import cubex2.cs3.ingame.gui.control.Button;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.Label;
import cubex2.cs3.ingame.gui.control.listbox.IListBoxItemClickListener;
import cubex2.cs3.ingame.gui.control.listbox.ListBox;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityList;

public class WindowEditPressurePlateTriggers
extends WindowEditBlockAttribute
implements IListBoxItemClickListener<String>,
ISelectElementCallback<String> {
    private Button btnAddInclude;
    private Button btnRemoveInclude;
    private ListBox<String> lbIncluded;
    private Button btnAddExclude;
    private Button btnRemoveExclude;
    private ListBox<String> lbExcluded;
    private String currentSelection;
    PressurePlateAttributes attributes;
    private List<String> included;
    private List<String> excluded;

    public WindowEditPressurePlateTriggers(WrappedBlock block) {
        super(block, "trigger", 293, 150);
        this.attributes = (PressurePlateAttributes)block.container;
        this.included = Lists.newArrayList((Object[])this.attributes.include);
        this.excluded = Lists.newArrayList((Object[])this.attributes.exclude);
        Label label = (Label)this.label("Included").at(7, 7).add();
        ListBoxDescription desc = new ListBoxDescription();
        desc.elements = this.included;
        desc.columns = 1;
        desc.sorted = true;
        desc.elementHeight = 18;
        desc.rows = 4;
        this.lbIncluded = (ListBox)this.listBox(desc).top(label, 7).left(7).width(136).add();
        this.btnAddInclude = (Button)this.button("Add").left(7).top(this.lbIncluded, 3).add();
        this.btnRemoveInclude = (Button)this.button("Remove").right(this.lbIncluded, 0, true).top(this.lbIncluded, 3).add();
        this.btnRemoveInclude.setEnabled(false);
        label = (Label)this.label("Excluded").at(146, 7).add();
        desc = new ListBoxDescription();
        desc.elements = this.excluded;
        desc.columns = 1;
        desc.sorted = true;
        desc.elementHeight = 18;
        desc.rows = 4;
        this.lbExcluded = (ListBox)this.listBox(desc).top(label, 7).left(this.lbIncluded, 7).width(136).add();
        this.btnAddExclude = (Button)this.button("Add").left(this.lbExcluded, 0, true).top(this.lbExcluded, 3).add();
        this.btnRemoveExclude = (Button)this.button("Remove").right(7).top(this.lbExcluded, 3).add();
        this.btnRemoveExclude.setEnabled(false);
    }

    @Override
    protected void applyChanges() {
        this.attributes.include = this.included.toArray(new String[this.included.size()]);
        this.attributes.exclude = this.excluded.toArray(new String[this.excluded.size()]);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnAddInclude) {
            this.currentSelection = "include";
            WindowSelectString window = new WindowSelectString("Select Trigger", this.getIncludeTriggers());
            window.setCallback(this);
            GuiBase.openWindow(window);
        } else if (c == this.btnAddExclude) {
            this.currentSelection = "exclude";
            WindowSelectString window = new WindowSelectString("Select Trigger", this.getExcludeTriggers());
            window.setCallback(this);
            GuiBase.openWindow(window);
        } else if (c == this.btnRemoveInclude) {
            this.included.remove(this.lbIncluded.getSelectedItem());
            this.lbIncluded.updateElements(this.included);
        } else if (c == this.btnRemoveExclude) {
            this.excluded.remove(this.lbExcluded.getSelectedItem());
            this.lbExcluded.updateElements(this.excluded);
        } else {
            super.controlClicked(c, mouseX, mouseY);
        }
    }

    private List<String> getIncludeTriggers() {
        List<String> ret = this.getValidTriggers();
        ret.add("all");
        for (String s : this.included) {
            ret.remove(s);
        }
        return ret;
    }

    private List<String> getExcludeTriggers() {
        List<String> ret = this.getValidTriggers();
        for (String s : this.excluded) {
            ret.remove(s);
        }
        return ret;
    }

    private List<String> getValidTriggers() {
        ArrayList ret = Lists.newArrayList();
        ret.add("mobs");
        ret.add("players");
        ret.add("hostiles");
        ret.add("animals");
        ret.add("items");
        for (Object o : EntityList.field_75625_b.keySet()) {
            ret.add((String)o);
        }
        return ret;
    }

    @Override
    public void itemClicked(String item, ListBox<String> listBox, int button) {
        this.btnRemoveInclude.setEnabled(this.lbIncluded.getSelectedIndex() >= 0);
        this.btnRemoveExclude.setEnabled(this.lbExcluded.getSelectedIndex() >= 0);
    }

    @Override
    public void itemSelected(String element) {
        if (this.currentSelection.equals("include")) {
            this.included.add(element);
            this.lbIncluded.updateElements(this.included);
        } else {
            this.excluded.add(element);
            this.lbExcluded.updateElements(this.excluded);
        }
    }
}

