/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui.block;

import cubex2.cs3.block.attributes.BlockAttributes;
import cubex2.cs3.common.WrappedBlock;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.WindowSelectItem;
import cubex2.cs3.ingame.gui.block.WindowEditBlockAttribute;
import cubex2.cs3.ingame.gui.block.WindowEditDropData;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.listbox.IListBoxItemClickListener;
import cubex2.cs3.ingame.gui.control.listbox.ListBox;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;
import cubex2.cs3.util.BlockDrop;
import net.minecraft.item.ItemStack;

public class WindowEditDrops
extends WindowEditBlockAttribute
implements IWindowClosedListener,
IListBoxItemClickListener<BlockDrop.DropData> {
    private ListBox<BlockDrop.DropData> listBox;

    public WindowEditDrops(WrappedBlock block) {
        super(block, "drops", 53, 263, 160);
        ListBoxDescription desc = new ListBoxDescription(7, 7);
        desc.rows = 5;
        desc.columns = 1;
        desc.elementHeight = 22;
        desc.elements = ((BlockAttributes)this.container).drop.getDrops();
        desc.canSelect = true;
        this.listBox = (ListBox)this.listBox(desc).fillWidth(7).top(7).add();
        this.btnEdit.setEnabled(false);
        this.btnDelete.setEnabled(false);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnNew) {
            GuiBase.openWindow(new WindowSelectItem(false));
        } else if (c == this.btnDelete) {
            BlockDrop.DropData drop = this.listBox.getSelectedItem();
            ((BlockAttributes)this.container).drop.getDrops().remove(drop);
            this.listBox.updateElements(((BlockAttributes)this.container).drop.getDrops());
            this.btnDelete.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.wrappedBlock.getPack().save();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    protected void handleEditButtonClicked() {
        this.applyChanges();
    }

    @Override
    protected void applyChanges() {
        GuiBase.openWindow(new WindowEditDropData(this.wrappedBlock, this.listBox.getSelectedItem()));
    }

    @Override
    public void itemClicked(BlockDrop.DropData item, ListBox<BlockDrop.DropData> listBox, int button) {
        this.btnEdit.setEnabled(listBox.getSelectedIndex() != -1);
        this.btnDelete.setEnabled(listBox.getSelectedIndex() != -1);
    }

    public void windowClosed(Window window) {
        if (window instanceof WindowSelectItem) {
            WindowSelectItem wdw = (WindowSelectItem)window;
            ItemStack stack = wdw.getSelectedStack();
            if (stack != null) {
                BlockDrop.DropData drop = new BlockDrop.DropData(stack.func_77973_b(), stack.func_77960_j(), 1, 1);
                ((BlockAttributes)this.container).drop.getDrops().add(drop);
                this.listBox.updateElements(((BlockAttributes)this.container).drop.getDrops());
                this.wrappedBlock.getPack().save();
            }
        } else if (window instanceof WindowEditDropData) {
            this.listBox.updateElements(((BlockAttributes)this.container).drop.getDrops());
        }
        this.btnEdit.setEnabled(this.listBox.getSelectedIndex() != -1);
        this.btnDelete.setEnabled(this.listBox.getSelectedIndex() != -1);
    }
}

