/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.ISelectElementCallback;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.listbox.IListBoxItemClickListener;
import cubex2.cs3.ingame.gui.control.listbox.ListBox;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;
import java.util.List;

public class WindowSelectString
extends Window
implements IListBoxItemClickListener<String> {
    private String selectedElement;
    private ISelectElementCallback<String> callback;

    public WindowSelectString(String title, List<String> elements) {
        super(title, 66, 200, 150);
        ListBoxDescription desc = new ListBoxDescription(7, 7);
        desc.elementHeight = 18;
        desc.columns = 1;
        desc.rows = 6;
        desc.elements = elements;
        desc.sorted = true;
        this.listBox(desc).fillWidth(7).top(7).add();
        this.btnSelect.setEnabled(false);
    }

    public ISelectElementCallback<String> getCallback() {
        return this.callback;
    }

    public void setCallback(ISelectElementCallback<String> callback) {
        this.callback = callback;
    }

    public String getSelectedElement() {
        return this.selectedElement;
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCancel) {
            this.selectedElement = null;
            GuiBase.openPrevWindow();
        } else if (c == this.btnSelect) {
            if (this.callback != null) {
                this.callback.itemSelected(this.selectedElement);
            }
            GuiBase.openPrevWindow();
        } else {
            super.controlClicked(c, mouseX, mouseY);
        }
    }

    @Override
    public void itemClicked(String item, ListBox<String> listBox, int button) {
        this.btnSelect.setEnabled(listBox.getSelectedIndex() != -1);
        this.selectedElement = listBox.getSelectedItem();
    }
}

