/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.IValueListener;
import cubex2.cs3.ingame.gui.control.ItemSelectionArray;
import cubex2.cs3.ingame.gui.control.Tab;
import cubex2.cs3.ingame.gui.control.TabChangedListener;
import cubex2.cs3.ingame.gui.control.TabControl;
import cubex2.cs3.ingame.gui.control.builder.ItemSelectionArrayBuilder;
import cubex2.cs3.ingame.gui.control.listbox.IListBoxItemClickListener;
import cubex2.cs3.ingame.gui.control.listbox.ListBox;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;
import cubex2.cs3.util.Filter;
import cubex2.cs3.util.ItemStackHelper;
import cubex2.cs3.util.OreDictionaryClass;
import cubex2.cs3.util.RecipeInput;
import net.minecraft.item.ItemStack;

public class WindowSelectRecipeInput
extends Window
implements IListBoxItemClickListener,
TabChangedListener {
    private BaseContentPack pack;
    private ItemSelectionArray itemsArray;
    private ListBox<OreDictionaryClass> lbOreDictClasses;
    private TabControl tabControl;
    private Object selectedInput = null;
    private final IValueListener<ItemSelectionArray> listener = new IValueListener<ItemSelectionArray>(){

        @Override
        public void onValueChanged(ItemSelectionArray control) {
            WindowSelectRecipeInput.this.btnSelect.setEnabled(control.getSelectedStack() != null);
        }
    };

    public WindowSelectRecipeInput(BaseContentPack pack) {
        super("Select", 66, 197, 211);
        this.pack = pack;
        this.tabControl = (TabControl)this.tabControl(70, 20).fill().add();
        Tab itemTab = this.tabControl.addTab("Items");
        Tab oreTab = this.tabControl.addTab("Ore Classes");
        this.itemsArray = (ItemSelectionArray)new ItemSelectionArrayBuilder(ItemStackHelper.getAllItemStacks(), this.defaultBuilderContainer).left(7).top(7).right(7).height(177).add();
        this.itemsArray.listener = this.listener;
        this.itemsArray.filter = Filter.ITEM_STACK;
        this.claimFocus(this.itemsArray.getSearchBox());
        ListBoxDescription desc1 = new ListBoxDescription(7, 7);
        desc1.elementWidth = 22;
        desc1.elementHeight = 22;
        desc1.columns = 7;
        desc1.rows = 7;
        desc1.elements = OreDictionaryClass.getAllClasses();
        desc1.sorted = true;
        desc1.hasSearchBar = true;
        desc1.filter = Filter.ORE_CLASS;
        this.lbOreDictClasses = (ListBox)oreTab.listBox(desc1).left(7).top(7).right(7).add();
        this.btnSelect.setEnabled(false);
    }

    public RecipeInput getSelectedInput() {
        if (this.selectedInput == null) {
            return null;
        }
        return this.selectedInput instanceof ItemStack ? new RecipeInput((ItemStack)this.selectedInput) : new RecipeInput(((OreDictionaryClass)this.selectedInput).oreClass);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCancel) {
            this.selectedInput = null;
            GuiBase.openPrevWindow();
        } else if (c == this.btnSelect) {
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    public void itemClicked(Object item, ListBox listBox, int button) {
        this.btnSelect.setEnabled(listBox.getSelectedIndex() != -1);
        this.selectedInput = listBox.getSelectedItem();
    }

    @Override
    public void tabChanged(TabControl tabControl, Tab tab) {
        if (tab.title.equals("Items")) {
            this.claimFocus(this.itemsArray.getSearchBox());
        } else {
            this.claimFocus(this.lbOreDictClasses.getSearchBox());
        }
    }
}

